// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: gateway.proto

package com.alibaba.nacos.istio.model;

/**
 * <pre>
 * `Server` describes the properties of the proxy on a given load balancer
 * port. For example,
 * ```yaml
 * apiVersion: networking.istio.io/v1alpha3
 * kind: Gateway
 * metadata:
 *   name: my-ingress
 * spec:
 *   selector:
 *     app: my-ingress-gateway
 *   servers:
 *   - port:
 *       number: 80
 *       name: http2
 *       protocol: HTTP2
 *     hosts:
 *     - "*"
 * ```
 * Another example
 * ```yaml
 * apiVersion: networking.istio.io/v1alpha3
 * kind: Gateway
 * metadata:
 *   name: my-tcp-ingress
 * spec:
 *   selector:
 *     app: my-tcp-ingress-gateway
 *   servers:
 *   - port:
 *       number: 27018
 *       name: mongo
 *       protocol: MONGO
 *     hosts:
 *     - "*"
 * ```
 * The following is an example of TLS configuration for port 443
 * ```yaml
 * apiVersion: networking.istio.io/v1alpha3
 * kind: Gateway
 * metadata:
 *   name: my-tls-ingress
 * spec:
 *   selector:
 *     app: my-tls-ingress-gateway
 *   servers:
 *   - port:
 *       number: 443
 *       name: https
 *       protocol: HTTPS
 *     hosts:
 *     - "*"
 *     tls:
 *       mode: SIMPLE
 *       serverCertificate: /etc/certs/server.pem
 *       privateKey: /etc/certs/privatekey.pem
 * ```
 * </pre>
 *
 * Protobuf type {@code istio.networking.v1alpha3.Server}
 */
public  final class Server extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Server)
    ServerOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Server.newBuilder() to construct.
  private Server(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Server() {
    bind_ = "";
    hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    defaultEndpoint_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Server();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Server(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            com.alibaba.nacos.istio.model.Port.Builder subBuilder = null;
            if (port_ != null) {
              subBuilder = port_.toBuilder();
            }
            port_ = input.readMessage(com.alibaba.nacos.istio.model.Port.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(port_);
              port_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              hosts_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000001;
            }
            hosts_.add(s);
            break;
          }
          case 26: {
            com.alibaba.nacos.istio.model.Server.TLSOptions.Builder subBuilder = null;
            if (tls_ != null) {
              subBuilder = tls_.toBuilder();
            }
            tls_ = input.readMessage(com.alibaba.nacos.istio.model.Server.TLSOptions.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(tls_);
              tls_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            bind_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            defaultEndpoint_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        hosts_ = hosts_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.alibaba.nacos.istio.model.Server.class, com.alibaba.nacos.istio.model.Server.Builder.class);
  }

  public interface TLSOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.Server.TLSOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * If set to true, the load balancer will send a 301 redirect for all
     * http connections, asking the clients to use HTTPS.
     * </pre>
     *
     * <code>bool https_redirect = 1;</code>
     * @return The httpsRedirect.
     */
    boolean getHttpsRedirect();

    /**
     * <pre>
     * Optional: Indicates whether connections to this port should be
     * secured using TLS. The value of this field determines how TLS is
     * enforced.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     * <pre>
     * Optional: Indicates whether connections to this port should be
     * secured using TLS. The value of this field determines how TLS is
     * enforced.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
     * @return The mode.
     */
    com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode getMode();

    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server-side TLS certificate to use.
     * </pre>
     *
     * <code>string server_certificate = 3;</code>
     * @return The serverCertificate.
     */
    java.lang.String getServerCertificate();
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server-side TLS certificate to use.
     * </pre>
     *
     * <code>string server_certificate = 3;</code>
     * @return The bytes for serverCertificate.
     */
    com.google.protobuf.ByteString
        getServerCertificateBytes();

    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server's private key.
     * </pre>
     *
     * <code>string private_key = 4;</code>
     * @return The privateKey.
     */
    java.lang.String getPrivateKey();
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server's private key.
     * </pre>
     *
     * <code>string private_key = 4;</code>
     * @return The bytes for privateKey.
     */
    com.google.protobuf.ByteString
        getPrivateKeyBytes();

    /**
     * <pre>
     * REQUIRED if mode is `MUTUAL`. The path to a file containing
     * certificate authority certificates to use in verifying a presented
     * client side certificate.
     * </pre>
     *
     * <code>string ca_certificates = 5;</code>
     * @return The caCertificates.
     */
    java.lang.String getCaCertificates();
    /**
     * <pre>
     * REQUIRED if mode is `MUTUAL`. The path to a file containing
     * certificate authority certificates to use in verifying a presented
     * client side certificate.
     * </pre>
     *
     * <code>string ca_certificates = 5;</code>
     * @return The bytes for caCertificates.
     */
    com.google.protobuf.ByteString
        getCaCertificatesBytes();

    /**
     * <pre>
     * The credentialName stands for a unique identifier that can be used
     * to identify the serverCertificate and the privateKey. The
     * credentialName appended with suffix "-cacert" is used to identify
     * the CaCertificates associated with this server. Gateway workloads
     * capable of fetching credentials from a remote credential store such
     * as Kubernetes secrets, will be configured to retrieve the
     * serverCertificate and the privateKey using credentialName, instead
     * of using the file system paths specified above. If using mutual TLS,
     * gateway workload instances will retrieve the CaCertificates using
     * credentialName-cacert. The semantics of the name are platform
     * dependent.  In Kubernetes, the default Istio supplied credential
     * server expects the credentialName to match the name of the
     * Kubernetes secret that holds the server certificate, the private
     * key, and the CA certificate (if using mutual TLS). Set the
     * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
     * enable the dynamic credential fetching feature.
     * </pre>
     *
     * <code>string credential_name = 10;</code>
     * @return The credentialName.
     */
    java.lang.String getCredentialName();
    /**
     * <pre>
     * The credentialName stands for a unique identifier that can be used
     * to identify the serverCertificate and the privateKey. The
     * credentialName appended with suffix "-cacert" is used to identify
     * the CaCertificates associated with this server. Gateway workloads
     * capable of fetching credentials from a remote credential store such
     * as Kubernetes secrets, will be configured to retrieve the
     * serverCertificate and the privateKey using credentialName, instead
     * of using the file system paths specified above. If using mutual TLS,
     * gateway workload instances will retrieve the CaCertificates using
     * credentialName-cacert. The semantics of the name are platform
     * dependent.  In Kubernetes, the default Istio supplied credential
     * server expects the credentialName to match the name of the
     * Kubernetes secret that holds the server certificate, the private
     * key, and the CA certificate (if using mutual TLS). Set the
     * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
     * enable the dynamic credential fetching feature.
     * </pre>
     *
     * <code>string credential_name = 10;</code>
     * @return The bytes for credentialName.
     */
    com.google.protobuf.ByteString
        getCredentialNameBytes();

    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @return A list containing the subjectAltNames.
     */
    java.util.List<java.lang.String>
        getSubjectAltNamesList();
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @return The count of subjectAltNames.
     */
    int getSubjectAltNamesCount();
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @param index The index of the element to return.
     * @return The subjectAltNames at the given index.
     */
    java.lang.String getSubjectAltNames(int index);
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @param index The index of the value to return.
     * @return The bytes of the subjectAltNames at the given index.
     */
    com.google.protobuf.ByteString
        getSubjectAltNamesBytes(int index);

    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @return A list containing the verifyCertificateSpki.
     */
    java.util.List<java.lang.String>
        getVerifyCertificateSpkiList();
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @return The count of verifyCertificateSpki.
     */
    int getVerifyCertificateSpkiCount();
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @param index The index of the element to return.
     * @return The verifyCertificateSpki at the given index.
     */
    java.lang.String getVerifyCertificateSpki(int index);
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @param index The index of the value to return.
     * @return The bytes of the verifyCertificateSpki at the given index.
     */
    com.google.protobuf.ByteString
        getVerifyCertificateSpkiBytes(int index);

    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @return A list containing the verifyCertificateHash.
     */
    java.util.List<java.lang.String>
        getVerifyCertificateHashList();
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @return The count of verifyCertificateHash.
     */
    int getVerifyCertificateHashCount();
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @param index The index of the element to return.
     * @return The verifyCertificateHash at the given index.
     */
    java.lang.String getVerifyCertificateHash(int index);
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @param index The index of the value to return.
     * @return The bytes of the verifyCertificateHash at the given index.
     */
    com.google.protobuf.ByteString
        getVerifyCertificateHashBytes(int index);

    /**
     * <pre>
     * Optional: Minimum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
     * @return The enum numeric value on the wire for minProtocolVersion.
     */
    int getMinProtocolVersionValue();
    /**
     * <pre>
     * Optional: Minimum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
     * @return The minProtocolVersion.
     */
    com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMinProtocolVersion();

    /**
     * <pre>
     * Optional: Maximum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
     * @return The enum numeric value on the wire for maxProtocolVersion.
     */
    int getMaxProtocolVersionValue();
    /**
     * <pre>
     * Optional: Maximum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
     * @return The maxProtocolVersion.
     */
    com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMaxProtocolVersion();

    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @return A list containing the cipherSuites.
     */
    java.util.List<java.lang.String>
        getCipherSuitesList();
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @return The count of cipherSuites.
     */
    int getCipherSuitesCount();
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @param index The index of the element to return.
     * @return The cipherSuites at the given index.
     */
    java.lang.String getCipherSuites(int index);
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @param index The index of the value to return.
     * @return The bytes of the cipherSuites at the given index.
     */
    com.google.protobuf.ByteString
        getCipherSuitesBytes(int index);
  }
  /**
   * Protobuf type {@code istio.networking.v1alpha3.Server.TLSOptions}
   */
  public  static final class TLSOptions extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Server.TLSOptions)
      TLSOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TLSOptions.newBuilder() to construct.
    private TLSOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TLSOptions() {
      mode_ = 0;
      serverCertificate_ = "";
      privateKey_ = "";
      caCertificates_ = "";
      credentialName_ = "";
      subjectAltNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      verifyCertificateSpki_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      verifyCertificateHash_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      minProtocolVersion_ = 0;
      maxProtocolVersion_ = 0;
      cipherSuites_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TLSOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TLSOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {

              httpsRedirect_ = input.readBool();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              mode_ = rawValue;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              serverCertificate_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              privateKey_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              caCertificates_ = s;
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                subjectAltNames_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              subjectAltNames_.add(s);
              break;
            }
            case 56: {
              int rawValue = input.readEnum();

              minProtocolVersion_ = rawValue;
              break;
            }
            case 64: {
              int rawValue = input.readEnum();

              maxProtocolVersion_ = rawValue;
              break;
            }
            case 74: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                cipherSuites_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              cipherSuites_.add(s);
              break;
            }
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();

              credentialName_ = s;
              break;
            }
            case 90: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                verifyCertificateSpki_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              verifyCertificateSpki_.add(s);
              break;
            }
            case 98: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                verifyCertificateHash_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              verifyCertificateHash_.add(s);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          subjectAltNames_ = subjectAltNames_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000008) != 0)) {
          cipherSuites_ = cipherSuites_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          verifyCertificateSpki_ = verifyCertificateSpki_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          verifyCertificateHash_ = verifyCertificateHash_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_TLSOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_TLSOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.alibaba.nacos.istio.model.Server.TLSOptions.class, com.alibaba.nacos.istio.model.Server.TLSOptions.Builder.class);
    }

    /**
     * <pre>
     * TLS modes enforced by the proxy
     * </pre>
     *
     * Protobuf enum {@code istio.networking.v1alpha3.Server.TLSOptions.TLSmode}
     */
    public enum TLSmode
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * The SNI string presented by the client will be used as the match
       * criterion in a VirtualService TLS route to determine the
       * destination service from the service registry.
       * </pre>
       *
       * <code>PASSTHROUGH = 0;</code>
       */
      PASSTHROUGH(0),
      /**
       * <pre>
       * Secure connections with standard TLS semantics.
       * </pre>
       *
       * <code>SIMPLE = 1;</code>
       */
      SIMPLE(1),
      /**
       * <pre>
       * Secure connections to the downstream using mutual TLS by presenting
       * server certificates for authentication.
       * </pre>
       *
       * <code>MUTUAL = 2;</code>
       */
      MUTUAL(2),
      /**
       * <pre>
       * Similar to the passthrough mode, except servers with this TLS mode
       * do not require an associated VirtualService to map from the SNI
       * value to service in the registry. The destination details such as
       * the service/subset/port are encoded in the SNI value. The proxy
       * will forward to the upstream (Envoy) cluster (a group of
       * endpoints) specified by the SNI value. This server is typically
       * used to provide connectivity between services in disparate L3
       * networks that otherwise do not have direct connectivity between
       * their respective endpoints. Use of this mode assumes that both the
       * source and the destination are using Istio mTLS to secure traffic.
       * </pre>
       *
       * <code>AUTO_PASSTHROUGH = 3;</code>
       */
      AUTO_PASSTHROUGH(3),
      /**
       * <pre>
       * Secure connections from the downstream using mutual TLS by presenting
       * server certificates for authentication.
       * Compared to Mutual mode, this mode uses certificates, representing
       * gateway workload identity, generated automatically by Istio for
       * mTLS authentication. When this mode is used, all other fields in
       * `TLSOptions` should be empty.
       * </pre>
       *
       * <code>ISTIO_MUTUAL = 4;</code>
       */
      ISTIO_MUTUAL(4),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * The SNI string presented by the client will be used as the match
       * criterion in a VirtualService TLS route to determine the
       * destination service from the service registry.
       * </pre>
       *
       * <code>PASSTHROUGH = 0;</code>
       */
      public static final int PASSTHROUGH_VALUE = 0;
      /**
       * <pre>
       * Secure connections with standard TLS semantics.
       * </pre>
       *
       * <code>SIMPLE = 1;</code>
       */
      public static final int SIMPLE_VALUE = 1;
      /**
       * <pre>
       * Secure connections to the downstream using mutual TLS by presenting
       * server certificates for authentication.
       * </pre>
       *
       * <code>MUTUAL = 2;</code>
       */
      public static final int MUTUAL_VALUE = 2;
      /**
       * <pre>
       * Similar to the passthrough mode, except servers with this TLS mode
       * do not require an associated VirtualService to map from the SNI
       * value to service in the registry. The destination details such as
       * the service/subset/port are encoded in the SNI value. The proxy
       * will forward to the upstream (Envoy) cluster (a group of
       * endpoints) specified by the SNI value. This server is typically
       * used to provide connectivity between services in disparate L3
       * networks that otherwise do not have direct connectivity between
       * their respective endpoints. Use of this mode assumes that both the
       * source and the destination are using Istio mTLS to secure traffic.
       * </pre>
       *
       * <code>AUTO_PASSTHROUGH = 3;</code>
       */
      public static final int AUTO_PASSTHROUGH_VALUE = 3;
      /**
       * <pre>
       * Secure connections from the downstream using mutual TLS by presenting
       * server certificates for authentication.
       * Compared to Mutual mode, this mode uses certificates, representing
       * gateway workload identity, generated automatically by Istio for
       * mTLS authentication. When this mode is used, all other fields in
       * `TLSOptions` should be empty.
       * </pre>
       *
       * <code>ISTIO_MUTUAL = 4;</code>
       */
      public static final int ISTIO_MUTUAL_VALUE = 4;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TLSmode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TLSmode forNumber(int value) {
        switch (value) {
          case 0: return PASSTHROUGH;
          case 1: return SIMPLE;
          case 2: return MUTUAL;
          case 3: return AUTO_PASSTHROUGH;
          case 4: return ISTIO_MUTUAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TLSmode>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          TLSmode> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TLSmode>() {
              public TLSmode findValueByNumber(int number) {
                return TLSmode.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.alibaba.nacos.istio.model.Server.TLSOptions.getDescriptor().getEnumTypes().get(0);
      }

      private static final TLSmode[] VALUES = values();

      public static TLSmode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TLSmode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:istio.networking.v1alpha3.Server.TLSOptions.TLSmode)
    }

    /**
     * <pre>
     * TLS protocol versions.
     * </pre>
     *
     * Protobuf enum {@code istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol}
     */
    public enum TLSProtocol
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Automatically choose the optimal TLS version.
       * </pre>
       *
       * <code>TLS_AUTO = 0;</code>
       */
      TLS_AUTO(0),
      /**
       * <pre>
       * TLS version 1.0
       * </pre>
       *
       * <code>TLSV1_0 = 1;</code>
       */
      TLSV1_0(1),
      /**
       * <pre>
       * TLS version 1.1
       * </pre>
       *
       * <code>TLSV1_1 = 2;</code>
       */
      TLSV1_1(2),
      /**
       * <pre>
       * TLS version 1.2
       * </pre>
       *
       * <code>TLSV1_2 = 3;</code>
       */
      TLSV1_2(3),
      /**
       * <pre>
       * TLS version 1.3
       * </pre>
       *
       * <code>TLSV1_3 = 4;</code>
       */
      TLSV1_3(4),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * Automatically choose the optimal TLS version.
       * </pre>
       *
       * <code>TLS_AUTO = 0;</code>
       */
      public static final int TLS_AUTO_VALUE = 0;
      /**
       * <pre>
       * TLS version 1.0
       * </pre>
       *
       * <code>TLSV1_0 = 1;</code>
       */
      public static final int TLSV1_0_VALUE = 1;
      /**
       * <pre>
       * TLS version 1.1
       * </pre>
       *
       * <code>TLSV1_1 = 2;</code>
       */
      public static final int TLSV1_1_VALUE = 2;
      /**
       * <pre>
       * TLS version 1.2
       * </pre>
       *
       * <code>TLSV1_2 = 3;</code>
       */
      public static final int TLSV1_2_VALUE = 3;
      /**
       * <pre>
       * TLS version 1.3
       * </pre>
       *
       * <code>TLSV1_3 = 4;</code>
       */
      public static final int TLSV1_3_VALUE = 4;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TLSProtocol valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TLSProtocol forNumber(int value) {
        switch (value) {
          case 0: return TLS_AUTO;
          case 1: return TLSV1_0;
          case 2: return TLSV1_1;
          case 3: return TLSV1_2;
          case 4: return TLSV1_3;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TLSProtocol>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          TLSProtocol> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TLSProtocol>() {
              public TLSProtocol findValueByNumber(int number) {
                return TLSProtocol.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.alibaba.nacos.istio.model.Server.TLSOptions.getDescriptor().getEnumTypes().get(1);
      }

      private static final TLSProtocol[] VALUES = values();

      public static TLSProtocol valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TLSProtocol(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol)
    }

    public static final int HTTPS_REDIRECT_FIELD_NUMBER = 1;
    private boolean httpsRedirect_;
    /**
     * <pre>
     * If set to true, the load balancer will send a 301 redirect for all
     * http connections, asking the clients to use HTTPS.
     * </pre>
     *
     * <code>bool https_redirect = 1;</code>
     * @return The httpsRedirect.
     */
    public boolean getHttpsRedirect() {
      return httpsRedirect_;
    }

    public static final int MODE_FIELD_NUMBER = 2;
    private int mode_;
    /**
     * <pre>
     * Optional: Indicates whether connections to this port should be
     * secured using TLS. The value of this field determines how TLS is
     * enforced.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
     * @return The enum numeric value on the wire for mode.
     */
    public int getModeValue() {
      return mode_;
    }
    /**
     * <pre>
     * Optional: Indicates whether connections to this port should be
     * secured using TLS. The value of this field determines how TLS is
     * enforced.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
     * @return The mode.
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode getMode() {
      @SuppressWarnings("deprecation")
      com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.valueOf(mode_);
      return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.UNRECOGNIZED : result;
    }

    public static final int SERVER_CERTIFICATE_FIELD_NUMBER = 3;
    private volatile java.lang.Object serverCertificate_;
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server-side TLS certificate to use.
     * </pre>
     *
     * <code>string server_certificate = 3;</code>
     * @return The serverCertificate.
     */
    public java.lang.String getServerCertificate() {
      java.lang.Object ref = serverCertificate_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverCertificate_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server-side TLS certificate to use.
     * </pre>
     *
     * <code>string server_certificate = 3;</code>
     * @return The bytes for serverCertificate.
     */
    public com.google.protobuf.ByteString
        getServerCertificateBytes() {
      java.lang.Object ref = serverCertificate_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        serverCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIVATE_KEY_FIELD_NUMBER = 4;
    private volatile java.lang.Object privateKey_;
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server's private key.
     * </pre>
     *
     * <code>string private_key = 4;</code>
     * @return The privateKey.
     */
    public java.lang.String getPrivateKey() {
      java.lang.Object ref = privateKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateKey_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
     * holding the server's private key.
     * </pre>
     *
     * <code>string private_key = 4;</code>
     * @return The bytes for privateKey.
     */
    public com.google.protobuf.ByteString
        getPrivateKeyBytes() {
      java.lang.Object ref = privateKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        privateKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CA_CERTIFICATES_FIELD_NUMBER = 5;
    private volatile java.lang.Object caCertificates_;
    /**
     * <pre>
     * REQUIRED if mode is `MUTUAL`. The path to a file containing
     * certificate authority certificates to use in verifying a presented
     * client side certificate.
     * </pre>
     *
     * <code>string ca_certificates = 5;</code>
     * @return The caCertificates.
     */
    public java.lang.String getCaCertificates() {
      java.lang.Object ref = caCertificates_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        caCertificates_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * REQUIRED if mode is `MUTUAL`. The path to a file containing
     * certificate authority certificates to use in verifying a presented
     * client side certificate.
     * </pre>
     *
     * <code>string ca_certificates = 5;</code>
     * @return The bytes for caCertificates.
     */
    public com.google.protobuf.ByteString
        getCaCertificatesBytes() {
      java.lang.Object ref = caCertificates_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        caCertificates_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREDENTIAL_NAME_FIELD_NUMBER = 10;
    private volatile java.lang.Object credentialName_;
    /**
     * <pre>
     * The credentialName stands for a unique identifier that can be used
     * to identify the serverCertificate and the privateKey. The
     * credentialName appended with suffix "-cacert" is used to identify
     * the CaCertificates associated with this server. Gateway workloads
     * capable of fetching credentials from a remote credential store such
     * as Kubernetes secrets, will be configured to retrieve the
     * serverCertificate and the privateKey using credentialName, instead
     * of using the file system paths specified above. If using mutual TLS,
     * gateway workload instances will retrieve the CaCertificates using
     * credentialName-cacert. The semantics of the name are platform
     * dependent.  In Kubernetes, the default Istio supplied credential
     * server expects the credentialName to match the name of the
     * Kubernetes secret that holds the server certificate, the private
     * key, and the CA certificate (if using mutual TLS). Set the
     * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
     * enable the dynamic credential fetching feature.
     * </pre>
     *
     * <code>string credential_name = 10;</code>
     * @return The credentialName.
     */
    public java.lang.String getCredentialName() {
      java.lang.Object ref = credentialName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        credentialName_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The credentialName stands for a unique identifier that can be used
     * to identify the serverCertificate and the privateKey. The
     * credentialName appended with suffix "-cacert" is used to identify
     * the CaCertificates associated with this server. Gateway workloads
     * capable of fetching credentials from a remote credential store such
     * as Kubernetes secrets, will be configured to retrieve the
     * serverCertificate and the privateKey using credentialName, instead
     * of using the file system paths specified above. If using mutual TLS,
     * gateway workload instances will retrieve the CaCertificates using
     * credentialName-cacert. The semantics of the name are platform
     * dependent.  In Kubernetes, the default Istio supplied credential
     * server expects the credentialName to match the name of the
     * Kubernetes secret that holds the server certificate, the private
     * key, and the CA certificate (if using mutual TLS). Set the
     * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
     * enable the dynamic credential fetching feature.
     * </pre>
     *
     * <code>string credential_name = 10;</code>
     * @return The bytes for credentialName.
     */
    public com.google.protobuf.ByteString
        getCredentialNameBytes() {
      java.lang.Object ref = credentialName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        credentialName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBJECT_ALT_NAMES_FIELD_NUMBER = 6;
    private com.google.protobuf.LazyStringList subjectAltNames_;
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @return A list containing the subjectAltNames.
     */
    public com.google.protobuf.ProtocolStringList
        getSubjectAltNamesList() {
      return subjectAltNames_;
    }
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @return The count of subjectAltNames.
     */
    public int getSubjectAltNamesCount() {
      return subjectAltNames_.size();
    }
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @param index The index of the element to return.
     * @return The subjectAltNames at the given index.
     */
    public java.lang.String getSubjectAltNames(int index) {
      return subjectAltNames_.get(index);
    }
    /**
     * <pre>
     * A list of alternate names to verify the subject identity in the
     * certificate presented by the client.
     * </pre>
     *
     * <code>repeated string subject_alt_names = 6;</code>
     * @param index The index of the value to return.
     * @return The bytes of the subjectAltNames at the given index.
     */
    public com.google.protobuf.ByteString
        getSubjectAltNamesBytes(int index) {
      return subjectAltNames_.getByteString(index);
    }

    public static final int VERIFY_CERTIFICATE_SPKI_FIELD_NUMBER = 11;
    private com.google.protobuf.LazyStringList verifyCertificateSpki_;
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @return A list containing the verifyCertificateSpki.
     */
    public com.google.protobuf.ProtocolStringList
        getVerifyCertificateSpkiList() {
      return verifyCertificateSpki_;
    }
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @return The count of verifyCertificateSpki.
     */
    public int getVerifyCertificateSpkiCount() {
      return verifyCertificateSpki_.size();
    }
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @param index The index of the element to return.
     * @return The verifyCertificateSpki at the given index.
     */
    public java.lang.String getVerifyCertificateSpki(int index) {
      return verifyCertificateSpki_.get(index);
    }
    /**
     * <pre>
     * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
     * authorized client certificates.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_spki = 11;</code>
     * @param index The index of the value to return.
     * @return The bytes of the verifyCertificateSpki at the given index.
     */
    public com.google.protobuf.ByteString
        getVerifyCertificateSpkiBytes(int index) {
      return verifyCertificateSpki_.getByteString(index);
    }

    public static final int VERIFY_CERTIFICATE_HASH_FIELD_NUMBER = 12;
    private com.google.protobuf.LazyStringList verifyCertificateHash_;
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @return A list containing the verifyCertificateHash.
     */
    public com.google.protobuf.ProtocolStringList
        getVerifyCertificateHashList() {
      return verifyCertificateHash_;
    }
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @return The count of verifyCertificateHash.
     */
    public int getVerifyCertificateHashCount() {
      return verifyCertificateHash_.size();
    }
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @param index The index of the element to return.
     * @return The verifyCertificateHash at the given index.
     */
    public java.lang.String getVerifyCertificateHash(int index) {
      return verifyCertificateHash_.get(index);
    }
    /**
     * <pre>
     * An optional list of hex-encoded SHA-256 hashes of the
     * authorized client certificates. Both simple and colon separated
     * formats are acceptable.
     * Note: When both verify_certificate_hash and verify_certificate_spki
     * are specified, a hash matching either value will result in the
     * certificate being accepted.
     * </pre>
     *
     * <code>repeated string verify_certificate_hash = 12;</code>
     * @param index The index of the value to return.
     * @return The bytes of the verifyCertificateHash at the given index.
     */
    public com.google.protobuf.ByteString
        getVerifyCertificateHashBytes(int index) {
      return verifyCertificateHash_.getByteString(index);
    }

    public static final int MIN_PROTOCOL_VERSION_FIELD_NUMBER = 7;
    private int minProtocolVersion_;
    /**
     * <pre>
     * Optional: Minimum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
     * @return The enum numeric value on the wire for minProtocolVersion.
     */
    public int getMinProtocolVersionValue() {
      return minProtocolVersion_;
    }
    /**
     * <pre>
     * Optional: Minimum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
     * @return The minProtocolVersion.
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMinProtocolVersion() {
      @SuppressWarnings("deprecation")
      com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.valueOf(minProtocolVersion_);
      return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.UNRECOGNIZED : result;
    }

    public static final int MAX_PROTOCOL_VERSION_FIELD_NUMBER = 8;
    private int maxProtocolVersion_;
    /**
     * <pre>
     * Optional: Maximum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
     * @return The enum numeric value on the wire for maxProtocolVersion.
     */
    public int getMaxProtocolVersionValue() {
      return maxProtocolVersion_;
    }
    /**
     * <pre>
     * Optional: Maximum TLS protocol version.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
     * @return The maxProtocolVersion.
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMaxProtocolVersion() {
      @SuppressWarnings("deprecation")
      com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.valueOf(maxProtocolVersion_);
      return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.UNRECOGNIZED : result;
    }

    public static final int CIPHER_SUITES_FIELD_NUMBER = 9;
    private com.google.protobuf.LazyStringList cipherSuites_;
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @return A list containing the cipherSuites.
     */
    public com.google.protobuf.ProtocolStringList
        getCipherSuitesList() {
      return cipherSuites_;
    }
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @return The count of cipherSuites.
     */
    public int getCipherSuitesCount() {
      return cipherSuites_.size();
    }
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @param index The index of the element to return.
     * @return The cipherSuites at the given index.
     */
    public java.lang.String getCipherSuites(int index) {
      return cipherSuites_.get(index);
    }
    /**
     * <pre>
     * Optional: If specified, only support the specified cipher list.
     * Otherwise default to the default cipher list supported by Envoy.
     * </pre>
     *
     * <code>repeated string cipher_suites = 9;</code>
     * @param index The index of the value to return.
     * @return The bytes of the cipherSuites at the given index.
     */
    public com.google.protobuf.ByteString
        getCipherSuitesBytes(int index) {
      return cipherSuites_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (httpsRedirect_ != false) {
        output.writeBool(1, httpsRedirect_);
      }
      if (mode_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.PASSTHROUGH.getNumber()) {
        output.writeEnum(2, mode_);
      }
      if (!getServerCertificateBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serverCertificate_);
      }
      if (!getPrivateKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, privateKey_);
      }
      if (!getCaCertificatesBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, caCertificates_);
      }
      for (int i = 0; i < subjectAltNames_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, subjectAltNames_.getRaw(i));
      }
      if (minProtocolVersion_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.TLS_AUTO.getNumber()) {
        output.writeEnum(7, minProtocolVersion_);
      }
      if (maxProtocolVersion_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.TLS_AUTO.getNumber()) {
        output.writeEnum(8, maxProtocolVersion_);
      }
      for (int i = 0; i < cipherSuites_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, cipherSuites_.getRaw(i));
      }
      if (!getCredentialNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, credentialName_);
      }
      for (int i = 0; i < verifyCertificateSpki_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, verifyCertificateSpki_.getRaw(i));
      }
      for (int i = 0; i < verifyCertificateHash_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, verifyCertificateHash_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (httpsRedirect_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, httpsRedirect_);
      }
      if (mode_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.PASSTHROUGH.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, mode_);
      }
      if (!getServerCertificateBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serverCertificate_);
      }
      if (!getPrivateKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, privateKey_);
      }
      if (!getCaCertificatesBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, caCertificates_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < subjectAltNames_.size(); i++) {
          dataSize += computeStringSizeNoTag(subjectAltNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSubjectAltNamesList().size();
      }
      if (minProtocolVersion_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.TLS_AUTO.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(7, minProtocolVersion_);
      }
      if (maxProtocolVersion_ != com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.TLS_AUTO.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(8, maxProtocolVersion_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < cipherSuites_.size(); i++) {
          dataSize += computeStringSizeNoTag(cipherSuites_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCipherSuitesList().size();
      }
      if (!getCredentialNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, credentialName_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < verifyCertificateSpki_.size(); i++) {
          dataSize += computeStringSizeNoTag(verifyCertificateSpki_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getVerifyCertificateSpkiList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < verifyCertificateHash_.size(); i++) {
          dataSize += computeStringSizeNoTag(verifyCertificateHash_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getVerifyCertificateHashList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.alibaba.nacos.istio.model.Server.TLSOptions)) {
        return super.equals(obj);
      }
      com.alibaba.nacos.istio.model.Server.TLSOptions other = (com.alibaba.nacos.istio.model.Server.TLSOptions) obj;

      if (getHttpsRedirect()
          != other.getHttpsRedirect()) return false;
      if (mode_ != other.mode_) return false;
      if (!getServerCertificate()
          .equals(other.getServerCertificate())) return false;
      if (!getPrivateKey()
          .equals(other.getPrivateKey())) return false;
      if (!getCaCertificates()
          .equals(other.getCaCertificates())) return false;
      if (!getCredentialName()
          .equals(other.getCredentialName())) return false;
      if (!getSubjectAltNamesList()
          .equals(other.getSubjectAltNamesList())) return false;
      if (!getVerifyCertificateSpkiList()
          .equals(other.getVerifyCertificateSpkiList())) return false;
      if (!getVerifyCertificateHashList()
          .equals(other.getVerifyCertificateHashList())) return false;
      if (minProtocolVersion_ != other.minProtocolVersion_) return false;
      if (maxProtocolVersion_ != other.maxProtocolVersion_) return false;
      if (!getCipherSuitesList()
          .equals(other.getCipherSuitesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HTTPS_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getHttpsRedirect());
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (37 * hash) + SERVER_CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getServerCertificate().hashCode();
      hash = (37 * hash) + PRIVATE_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateKey().hashCode();
      hash = (37 * hash) + CA_CERTIFICATES_FIELD_NUMBER;
      hash = (53 * hash) + getCaCertificates().hashCode();
      hash = (37 * hash) + CREDENTIAL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getCredentialName().hashCode();
      if (getSubjectAltNamesCount() > 0) {
        hash = (37 * hash) + SUBJECT_ALT_NAMES_FIELD_NUMBER;
        hash = (53 * hash) + getSubjectAltNamesList().hashCode();
      }
      if (getVerifyCertificateSpkiCount() > 0) {
        hash = (37 * hash) + VERIFY_CERTIFICATE_SPKI_FIELD_NUMBER;
        hash = (53 * hash) + getVerifyCertificateSpkiList().hashCode();
      }
      if (getVerifyCertificateHashCount() > 0) {
        hash = (37 * hash) + VERIFY_CERTIFICATE_HASH_FIELD_NUMBER;
        hash = (53 * hash) + getVerifyCertificateHashList().hashCode();
      }
      hash = (37 * hash) + MIN_PROTOCOL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + minProtocolVersion_;
      hash = (37 * hash) + MAX_PROTOCOL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + maxProtocolVersion_;
      if (getCipherSuitesCount() > 0) {
        hash = (37 * hash) + CIPHER_SUITES_FIELD_NUMBER;
        hash = (53 * hash) + getCipherSuitesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.alibaba.nacos.istio.model.Server.TLSOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.alibaba.nacos.istio.model.Server.TLSOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code istio.networking.v1alpha3.Server.TLSOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Server.TLSOptions)
        com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_TLSOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_TLSOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.alibaba.nacos.istio.model.Server.TLSOptions.class, com.alibaba.nacos.istio.model.Server.TLSOptions.Builder.class);
      }

      // Construct using com.alibaba.nacos.istio.model.Server.TLSOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        httpsRedirect_ = false;

        mode_ = 0;

        serverCertificate_ = "";

        privateKey_ = "";

        caCertificates_ = "";

        credentialName_ = "";

        subjectAltNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        verifyCertificateSpki_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        verifyCertificateHash_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        minProtocolVersion_ = 0;

        maxProtocolVersion_ = 0;

        cipherSuites_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_TLSOptions_descriptor;
      }

      @java.lang.Override
      public com.alibaba.nacos.istio.model.Server.TLSOptions getDefaultInstanceForType() {
        return com.alibaba.nacos.istio.model.Server.TLSOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.alibaba.nacos.istio.model.Server.TLSOptions build() {
        com.alibaba.nacos.istio.model.Server.TLSOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.alibaba.nacos.istio.model.Server.TLSOptions buildPartial() {
        com.alibaba.nacos.istio.model.Server.TLSOptions result = new com.alibaba.nacos.istio.model.Server.TLSOptions(this);
        int from_bitField0_ = bitField0_;
        result.httpsRedirect_ = httpsRedirect_;
        result.mode_ = mode_;
        result.serverCertificate_ = serverCertificate_;
        result.privateKey_ = privateKey_;
        result.caCertificates_ = caCertificates_;
        result.credentialName_ = credentialName_;
        if (((bitField0_ & 0x00000001) != 0)) {
          subjectAltNames_ = subjectAltNames_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.subjectAltNames_ = subjectAltNames_;
        if (((bitField0_ & 0x00000002) != 0)) {
          verifyCertificateSpki_ = verifyCertificateSpki_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.verifyCertificateSpki_ = verifyCertificateSpki_;
        if (((bitField0_ & 0x00000004) != 0)) {
          verifyCertificateHash_ = verifyCertificateHash_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.verifyCertificateHash_ = verifyCertificateHash_;
        result.minProtocolVersion_ = minProtocolVersion_;
        result.maxProtocolVersion_ = maxProtocolVersion_;
        if (((bitField0_ & 0x00000008) != 0)) {
          cipherSuites_ = cipherSuites_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.cipherSuites_ = cipherSuites_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.alibaba.nacos.istio.model.Server.TLSOptions) {
          return mergeFrom((com.alibaba.nacos.istio.model.Server.TLSOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.alibaba.nacos.istio.model.Server.TLSOptions other) {
        if (other == com.alibaba.nacos.istio.model.Server.TLSOptions.getDefaultInstance()) return this;
        if (other.getHttpsRedirect() != false) {
          setHttpsRedirect(other.getHttpsRedirect());
        }
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (!other.getServerCertificate().isEmpty()) {
          serverCertificate_ = other.serverCertificate_;
          onChanged();
        }
        if (!other.getPrivateKey().isEmpty()) {
          privateKey_ = other.privateKey_;
          onChanged();
        }
        if (!other.getCaCertificates().isEmpty()) {
          caCertificates_ = other.caCertificates_;
          onChanged();
        }
        if (!other.getCredentialName().isEmpty()) {
          credentialName_ = other.credentialName_;
          onChanged();
        }
        if (!other.subjectAltNames_.isEmpty()) {
          if (subjectAltNames_.isEmpty()) {
            subjectAltNames_ = other.subjectAltNames_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSubjectAltNamesIsMutable();
            subjectAltNames_.addAll(other.subjectAltNames_);
          }
          onChanged();
        }
        if (!other.verifyCertificateSpki_.isEmpty()) {
          if (verifyCertificateSpki_.isEmpty()) {
            verifyCertificateSpki_ = other.verifyCertificateSpki_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureVerifyCertificateSpkiIsMutable();
            verifyCertificateSpki_.addAll(other.verifyCertificateSpki_);
          }
          onChanged();
        }
        if (!other.verifyCertificateHash_.isEmpty()) {
          if (verifyCertificateHash_.isEmpty()) {
            verifyCertificateHash_ = other.verifyCertificateHash_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureVerifyCertificateHashIsMutable();
            verifyCertificateHash_.addAll(other.verifyCertificateHash_);
          }
          onChanged();
        }
        if (other.minProtocolVersion_ != 0) {
          setMinProtocolVersionValue(other.getMinProtocolVersionValue());
        }
        if (other.maxProtocolVersion_ != 0) {
          setMaxProtocolVersionValue(other.getMaxProtocolVersionValue());
        }
        if (!other.cipherSuites_.isEmpty()) {
          if (cipherSuites_.isEmpty()) {
            cipherSuites_ = other.cipherSuites_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureCipherSuitesIsMutable();
            cipherSuites_.addAll(other.cipherSuites_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.alibaba.nacos.istio.model.Server.TLSOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.alibaba.nacos.istio.model.Server.TLSOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private boolean httpsRedirect_ ;
      /**
       * <pre>
       * If set to true, the load balancer will send a 301 redirect for all
       * http connections, asking the clients to use HTTPS.
       * </pre>
       *
       * <code>bool https_redirect = 1;</code>
       * @return The httpsRedirect.
       */
      public boolean getHttpsRedirect() {
        return httpsRedirect_;
      }
      /**
       * <pre>
       * If set to true, the load balancer will send a 301 redirect for all
       * http connections, asking the clients to use HTTPS.
       * </pre>
       *
       * <code>bool https_redirect = 1;</code>
       * @param value The httpsRedirect to set.
       * @return This builder for chaining.
       */
      public Builder setHttpsRedirect(boolean value) {
        
        httpsRedirect_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * If set to true, the load balancer will send a 301 redirect for all
       * http connections, asking the clients to use HTTPS.
       * </pre>
       *
       * <code>bool https_redirect = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearHttpsRedirect() {
        
        httpsRedirect_ = false;
        onChanged();
        return this;
      }

      private int mode_ = 0;
      /**
       * <pre>
       * Optional: Indicates whether connections to this port should be
       * secured using TLS. The value of this field determines how TLS is
       * enforced.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
       * @return The enum numeric value on the wire for mode.
       */
      public int getModeValue() {
        return mode_;
      }
      /**
       * <pre>
       * Optional: Indicates whether connections to this port should be
       * secured using TLS. The value of this field determines how TLS is
       * enforced.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Indicates whether connections to this port should be
       * secured using TLS. The value of this field determines how TLS is
       * enforced.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
       * @return The mode.
       */
      public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode getMode() {
        @SuppressWarnings("deprecation")
        com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.valueOf(mode_);
        return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Optional: Indicates whether connections to this port should be
       * secured using TLS. The value of this field determines how TLS is
       * enforced.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(com.alibaba.nacos.istio.model.Server.TLSOptions.TLSmode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Indicates whether connections to this port should be
       * secured using TLS. The value of this field determines how TLS is
       * enforced.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSmode mode = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        
        mode_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object serverCertificate_ = "";
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server-side TLS certificate to use.
       * </pre>
       *
       * <code>string server_certificate = 3;</code>
       * @return The serverCertificate.
       */
      public java.lang.String getServerCertificate() {
        java.lang.Object ref = serverCertificate_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serverCertificate_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server-side TLS certificate to use.
       * </pre>
       *
       * <code>string server_certificate = 3;</code>
       * @return The bytes for serverCertificate.
       */
      public com.google.protobuf.ByteString
          getServerCertificateBytes() {
        java.lang.Object ref = serverCertificate_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          serverCertificate_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server-side TLS certificate to use.
       * </pre>
       *
       * <code>string server_certificate = 3;</code>
       * @param value The serverCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setServerCertificate(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        serverCertificate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server-side TLS certificate to use.
       * </pre>
       *
       * <code>string server_certificate = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearServerCertificate() {
        
        serverCertificate_ = getDefaultInstance().getServerCertificate();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server-side TLS certificate to use.
       * </pre>
       *
       * <code>string server_certificate = 3;</code>
       * @param value The bytes for serverCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setServerCertificateBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        serverCertificate_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object privateKey_ = "";
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server's private key.
       * </pre>
       *
       * <code>string private_key = 4;</code>
       * @return The privateKey.
       */
      public java.lang.String getPrivateKey() {
        java.lang.Object ref = privateKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          privateKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server's private key.
       * </pre>
       *
       * <code>string private_key = 4;</code>
       * @return The bytes for privateKey.
       */
      public com.google.protobuf.ByteString
          getPrivateKeyBytes() {
        java.lang.Object ref = privateKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          privateKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server's private key.
       * </pre>
       *
       * <code>string private_key = 4;</code>
       * @param value The privateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        privateKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server's private key.
       * </pre>
       *
       * <code>string private_key = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearPrivateKey() {
        
        privateKey_ = getDefaultInstance().getPrivateKey();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
       * holding the server's private key.
       * </pre>
       *
       * <code>string private_key = 4;</code>
       * @param value The bytes for privateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        privateKey_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object caCertificates_ = "";
      /**
       * <pre>
       * REQUIRED if mode is `MUTUAL`. The path to a file containing
       * certificate authority certificates to use in verifying a presented
       * client side certificate.
       * </pre>
       *
       * <code>string ca_certificates = 5;</code>
       * @return The caCertificates.
       */
      public java.lang.String getCaCertificates() {
        java.lang.Object ref = caCertificates_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          caCertificates_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `MUTUAL`. The path to a file containing
       * certificate authority certificates to use in verifying a presented
       * client side certificate.
       * </pre>
       *
       * <code>string ca_certificates = 5;</code>
       * @return The bytes for caCertificates.
       */
      public com.google.protobuf.ByteString
          getCaCertificatesBytes() {
        java.lang.Object ref = caCertificates_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          caCertificates_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * REQUIRED if mode is `MUTUAL`. The path to a file containing
       * certificate authority certificates to use in verifying a presented
       * client side certificate.
       * </pre>
       *
       * <code>string ca_certificates = 5;</code>
       * @param value The caCertificates to set.
       * @return This builder for chaining.
       */
      public Builder setCaCertificates(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        caCertificates_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `MUTUAL`. The path to a file containing
       * certificate authority certificates to use in verifying a presented
       * client side certificate.
       * </pre>
       *
       * <code>string ca_certificates = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearCaCertificates() {
        
        caCertificates_ = getDefaultInstance().getCaCertificates();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REQUIRED if mode is `MUTUAL`. The path to a file containing
       * certificate authority certificates to use in verifying a presented
       * client side certificate.
       * </pre>
       *
       * <code>string ca_certificates = 5;</code>
       * @param value The bytes for caCertificates to set.
       * @return This builder for chaining.
       */
      public Builder setCaCertificatesBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        caCertificates_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object credentialName_ = "";
      /**
       * <pre>
       * The credentialName stands for a unique identifier that can be used
       * to identify the serverCertificate and the privateKey. The
       * credentialName appended with suffix "-cacert" is used to identify
       * the CaCertificates associated with this server. Gateway workloads
       * capable of fetching credentials from a remote credential store such
       * as Kubernetes secrets, will be configured to retrieve the
       * serverCertificate and the privateKey using credentialName, instead
       * of using the file system paths specified above. If using mutual TLS,
       * gateway workload instances will retrieve the CaCertificates using
       * credentialName-cacert. The semantics of the name are platform
       * dependent.  In Kubernetes, the default Istio supplied credential
       * server expects the credentialName to match the name of the
       * Kubernetes secret that holds the server certificate, the private
       * key, and the CA certificate (if using mutual TLS). Set the
       * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
       * enable the dynamic credential fetching feature.
       * </pre>
       *
       * <code>string credential_name = 10;</code>
       * @return The credentialName.
       */
      public java.lang.String getCredentialName() {
        java.lang.Object ref = credentialName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          credentialName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The credentialName stands for a unique identifier that can be used
       * to identify the serverCertificate and the privateKey. The
       * credentialName appended with suffix "-cacert" is used to identify
       * the CaCertificates associated with this server. Gateway workloads
       * capable of fetching credentials from a remote credential store such
       * as Kubernetes secrets, will be configured to retrieve the
       * serverCertificate and the privateKey using credentialName, instead
       * of using the file system paths specified above. If using mutual TLS,
       * gateway workload instances will retrieve the CaCertificates using
       * credentialName-cacert. The semantics of the name are platform
       * dependent.  In Kubernetes, the default Istio supplied credential
       * server expects the credentialName to match the name of the
       * Kubernetes secret that holds the server certificate, the private
       * key, and the CA certificate (if using mutual TLS). Set the
       * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
       * enable the dynamic credential fetching feature.
       * </pre>
       *
       * <code>string credential_name = 10;</code>
       * @return The bytes for credentialName.
       */
      public com.google.protobuf.ByteString
          getCredentialNameBytes() {
        java.lang.Object ref = credentialName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          credentialName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The credentialName stands for a unique identifier that can be used
       * to identify the serverCertificate and the privateKey. The
       * credentialName appended with suffix "-cacert" is used to identify
       * the CaCertificates associated with this server. Gateway workloads
       * capable of fetching credentials from a remote credential store such
       * as Kubernetes secrets, will be configured to retrieve the
       * serverCertificate and the privateKey using credentialName, instead
       * of using the file system paths specified above. If using mutual TLS,
       * gateway workload instances will retrieve the CaCertificates using
       * credentialName-cacert. The semantics of the name are platform
       * dependent.  In Kubernetes, the default Istio supplied credential
       * server expects the credentialName to match the name of the
       * Kubernetes secret that holds the server certificate, the private
       * key, and the CA certificate (if using mutual TLS). Set the
       * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
       * enable the dynamic credential fetching feature.
       * </pre>
       *
       * <code>string credential_name = 10;</code>
       * @param value The credentialName to set.
       * @return This builder for chaining.
       */
      public Builder setCredentialName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        credentialName_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The credentialName stands for a unique identifier that can be used
       * to identify the serverCertificate and the privateKey. The
       * credentialName appended with suffix "-cacert" is used to identify
       * the CaCertificates associated with this server. Gateway workloads
       * capable of fetching credentials from a remote credential store such
       * as Kubernetes secrets, will be configured to retrieve the
       * serverCertificate and the privateKey using credentialName, instead
       * of using the file system paths specified above. If using mutual TLS,
       * gateway workload instances will retrieve the CaCertificates using
       * credentialName-cacert. The semantics of the name are platform
       * dependent.  In Kubernetes, the default Istio supplied credential
       * server expects the credentialName to match the name of the
       * Kubernetes secret that holds the server certificate, the private
       * key, and the CA certificate (if using mutual TLS). Set the
       * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
       * enable the dynamic credential fetching feature.
       * </pre>
       *
       * <code>string credential_name = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearCredentialName() {
        
        credentialName_ = getDefaultInstance().getCredentialName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The credentialName stands for a unique identifier that can be used
       * to identify the serverCertificate and the privateKey. The
       * credentialName appended with suffix "-cacert" is used to identify
       * the CaCertificates associated with this server. Gateway workloads
       * capable of fetching credentials from a remote credential store such
       * as Kubernetes secrets, will be configured to retrieve the
       * serverCertificate and the privateKey using credentialName, instead
       * of using the file system paths specified above. If using mutual TLS,
       * gateway workload instances will retrieve the CaCertificates using
       * credentialName-cacert. The semantics of the name are platform
       * dependent.  In Kubernetes, the default Istio supplied credential
       * server expects the credentialName to match the name of the
       * Kubernetes secret that holds the server certificate, the private
       * key, and the CA certificate (if using mutual TLS). Set the
       * `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
       * enable the dynamic credential fetching feature.
       * </pre>
       *
       * <code>string credential_name = 10;</code>
       * @param value The bytes for credentialName to set.
       * @return This builder for chaining.
       */
      public Builder setCredentialNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        credentialName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList subjectAltNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureSubjectAltNamesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          subjectAltNames_ = new com.google.protobuf.LazyStringArrayList(subjectAltNames_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @return A list containing the subjectAltNames.
       */
      public com.google.protobuf.ProtocolStringList
          getSubjectAltNamesList() {
        return subjectAltNames_.getUnmodifiableView();
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @return The count of subjectAltNames.
       */
      public int getSubjectAltNamesCount() {
        return subjectAltNames_.size();
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param index The index of the element to return.
       * @return The subjectAltNames at the given index.
       */
      public java.lang.String getSubjectAltNames(int index) {
        return subjectAltNames_.get(index);
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param index The index of the value to return.
       * @return The bytes of the subjectAltNames at the given index.
       */
      public com.google.protobuf.ByteString
          getSubjectAltNamesBytes(int index) {
        return subjectAltNames_.getByteString(index);
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param index The index to set the value at.
       * @param value The subjectAltNames to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectAltNames(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSubjectAltNamesIsMutable();
        subjectAltNames_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param value The subjectAltNames to add.
       * @return This builder for chaining.
       */
      public Builder addSubjectAltNames(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param values The subjectAltNames to add.
       * @return This builder for chaining.
       */
      public Builder addAllSubjectAltNames(
          java.lang.Iterable<java.lang.String> values) {
        ensureSubjectAltNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, subjectAltNames_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearSubjectAltNames() {
        subjectAltNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of alternate names to verify the subject identity in the
       * certificate presented by the client.
       * </pre>
       *
       * <code>repeated string subject_alt_names = 6;</code>
       * @param value The bytes of the subjectAltNames to add.
       * @return This builder for chaining.
       */
      public Builder addSubjectAltNamesBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList verifyCertificateSpki_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureVerifyCertificateSpkiIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          verifyCertificateSpki_ = new com.google.protobuf.LazyStringArrayList(verifyCertificateSpki_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @return A list containing the verifyCertificateSpki.
       */
      public com.google.protobuf.ProtocolStringList
          getVerifyCertificateSpkiList() {
        return verifyCertificateSpki_.getUnmodifiableView();
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @return The count of verifyCertificateSpki.
       */
      public int getVerifyCertificateSpkiCount() {
        return verifyCertificateSpki_.size();
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param index The index of the element to return.
       * @return The verifyCertificateSpki at the given index.
       */
      public java.lang.String getVerifyCertificateSpki(int index) {
        return verifyCertificateSpki_.get(index);
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param index The index of the value to return.
       * @return The bytes of the verifyCertificateSpki at the given index.
       */
      public com.google.protobuf.ByteString
          getVerifyCertificateSpkiBytes(int index) {
        return verifyCertificateSpki_.getByteString(index);
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param index The index to set the value at.
       * @param value The verifyCertificateSpki to set.
       * @return This builder for chaining.
       */
      public Builder setVerifyCertificateSpki(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureVerifyCertificateSpkiIsMutable();
        verifyCertificateSpki_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param value The verifyCertificateSpki to add.
       * @return This builder for chaining.
       */
      public Builder addVerifyCertificateSpki(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureVerifyCertificateSpkiIsMutable();
        verifyCertificateSpki_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param values The verifyCertificateSpki to add.
       * @return This builder for chaining.
       */
      public Builder addAllVerifyCertificateSpki(
          java.lang.Iterable<java.lang.String> values) {
        ensureVerifyCertificateSpkiIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, verifyCertificateSpki_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearVerifyCertificateSpki() {
        verifyCertificateSpki_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of base64-encoded SHA-256 hashes of the SKPIs of
       * authorized client certificates.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_spki = 11;</code>
       * @param value The bytes of the verifyCertificateSpki to add.
       * @return This builder for chaining.
       */
      public Builder addVerifyCertificateSpkiBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureVerifyCertificateSpkiIsMutable();
        verifyCertificateSpki_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList verifyCertificateHash_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureVerifyCertificateHashIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          verifyCertificateHash_ = new com.google.protobuf.LazyStringArrayList(verifyCertificateHash_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @return A list containing the verifyCertificateHash.
       */
      public com.google.protobuf.ProtocolStringList
          getVerifyCertificateHashList() {
        return verifyCertificateHash_.getUnmodifiableView();
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @return The count of verifyCertificateHash.
       */
      public int getVerifyCertificateHashCount() {
        return verifyCertificateHash_.size();
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param index The index of the element to return.
       * @return The verifyCertificateHash at the given index.
       */
      public java.lang.String getVerifyCertificateHash(int index) {
        return verifyCertificateHash_.get(index);
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param index The index of the value to return.
       * @return The bytes of the verifyCertificateHash at the given index.
       */
      public com.google.protobuf.ByteString
          getVerifyCertificateHashBytes(int index) {
        return verifyCertificateHash_.getByteString(index);
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param index The index to set the value at.
       * @param value The verifyCertificateHash to set.
       * @return This builder for chaining.
       */
      public Builder setVerifyCertificateHash(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureVerifyCertificateHashIsMutable();
        verifyCertificateHash_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param value The verifyCertificateHash to add.
       * @return This builder for chaining.
       */
      public Builder addVerifyCertificateHash(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureVerifyCertificateHashIsMutable();
        verifyCertificateHash_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param values The verifyCertificateHash to add.
       * @return This builder for chaining.
       */
      public Builder addAllVerifyCertificateHash(
          java.lang.Iterable<java.lang.String> values) {
        ensureVerifyCertificateHashIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, verifyCertificateHash_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearVerifyCertificateHash() {
        verifyCertificateHash_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional list of hex-encoded SHA-256 hashes of the
       * authorized client certificates. Both simple and colon separated
       * formats are acceptable.
       * Note: When both verify_certificate_hash and verify_certificate_spki
       * are specified, a hash matching either value will result in the
       * certificate being accepted.
       * </pre>
       *
       * <code>repeated string verify_certificate_hash = 12;</code>
       * @param value The bytes of the verifyCertificateHash to add.
       * @return This builder for chaining.
       */
      public Builder addVerifyCertificateHashBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureVerifyCertificateHashIsMutable();
        verifyCertificateHash_.add(value);
        onChanged();
        return this;
      }

      private int minProtocolVersion_ = 0;
      /**
       * <pre>
       * Optional: Minimum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
       * @return The enum numeric value on the wire for minProtocolVersion.
       */
      public int getMinProtocolVersionValue() {
        return minProtocolVersion_;
      }
      /**
       * <pre>
       * Optional: Minimum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
       * @param value The enum numeric value on the wire for minProtocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMinProtocolVersionValue(int value) {
        minProtocolVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Minimum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
       * @return The minProtocolVersion.
       */
      public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMinProtocolVersion() {
        @SuppressWarnings("deprecation")
        com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.valueOf(minProtocolVersion_);
        return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Optional: Minimum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
       * @param value The minProtocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMinProtocolVersion(com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        minProtocolVersion_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Minimum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol min_protocol_version = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearMinProtocolVersion() {
        
        minProtocolVersion_ = 0;
        onChanged();
        return this;
      }

      private int maxProtocolVersion_ = 0;
      /**
       * <pre>
       * Optional: Maximum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
       * @return The enum numeric value on the wire for maxProtocolVersion.
       */
      public int getMaxProtocolVersionValue() {
        return maxProtocolVersion_;
      }
      /**
       * <pre>
       * Optional: Maximum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
       * @param value The enum numeric value on the wire for maxProtocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMaxProtocolVersionValue(int value) {
        maxProtocolVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Maximum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
       * @return The maxProtocolVersion.
       */
      public com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol getMaxProtocolVersion() {
        @SuppressWarnings("deprecation")
        com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol result = com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.valueOf(maxProtocolVersion_);
        return result == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Optional: Maximum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
       * @param value The maxProtocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMaxProtocolVersion(com.alibaba.nacos.istio.model.Server.TLSOptions.TLSProtocol value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        maxProtocolVersion_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: Maximum TLS protocol version.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Server.TLSOptions.TLSProtocol max_protocol_version = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearMaxProtocolVersion() {
        
        maxProtocolVersion_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList cipherSuites_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureCipherSuitesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          cipherSuites_ = new com.google.protobuf.LazyStringArrayList(cipherSuites_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @return A list containing the cipherSuites.
       */
      public com.google.protobuf.ProtocolStringList
          getCipherSuitesList() {
        return cipherSuites_.getUnmodifiableView();
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @return The count of cipherSuites.
       */
      public int getCipherSuitesCount() {
        return cipherSuites_.size();
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param index The index of the element to return.
       * @return The cipherSuites at the given index.
       */
      public java.lang.String getCipherSuites(int index) {
        return cipherSuites_.get(index);
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param index The index of the value to return.
       * @return The bytes of the cipherSuites at the given index.
       */
      public com.google.protobuf.ByteString
          getCipherSuitesBytes(int index) {
        return cipherSuites_.getByteString(index);
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param index The index to set the value at.
       * @param value The cipherSuites to set.
       * @return This builder for chaining.
       */
      public Builder setCipherSuites(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureCipherSuitesIsMutable();
        cipherSuites_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param value The cipherSuites to add.
       * @return This builder for chaining.
       */
      public Builder addCipherSuites(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureCipherSuitesIsMutable();
        cipherSuites_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param values The cipherSuites to add.
       * @return This builder for chaining.
       */
      public Builder addAllCipherSuites(
          java.lang.Iterable<java.lang.String> values) {
        ensureCipherSuitesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, cipherSuites_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearCipherSuites() {
        cipherSuites_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional: If specified, only support the specified cipher list.
       * Otherwise default to the default cipher list supported by Envoy.
       * </pre>
       *
       * <code>repeated string cipher_suites = 9;</code>
       * @param value The bytes of the cipherSuites to add.
       * @return This builder for chaining.
       */
      public Builder addCipherSuitesBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureCipherSuitesIsMutable();
        cipherSuites_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Server.TLSOptions)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Server.TLSOptions)
    private static final com.alibaba.nacos.istio.model.Server.TLSOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.alibaba.nacos.istio.model.Server.TLSOptions();
    }

    public static com.alibaba.nacos.istio.model.Server.TLSOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TLSOptions>
        PARSER = new com.google.protobuf.AbstractParser<TLSOptions>() {
      @java.lang.Override
      public TLSOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TLSOptions(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TLSOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TLSOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.alibaba.nacos.istio.model.Server.TLSOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int PORT_FIELD_NUMBER = 1;
  private com.alibaba.nacos.istio.model.Port port_;
  /**
   * <pre>
   * REQUIRED: The Port on which the proxy should listen for incoming
   * connections.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Port port = 1;</code>
   * @return Whether the port field is set.
   */
  public boolean hasPort() {
    return port_ != null;
  }
  /**
   * <pre>
   * REQUIRED: The Port on which the proxy should listen for incoming
   * connections.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Port port = 1;</code>
   * @return The port.
   */
  public com.alibaba.nacos.istio.model.Port getPort() {
    return port_ == null ? com.alibaba.nacos.istio.model.Port.getDefaultInstance() : port_;
  }
  /**
   * <pre>
   * REQUIRED: The Port on which the proxy should listen for incoming
   * connections.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Port port = 1;</code>
   */
  public com.alibaba.nacos.istio.model.PortOrBuilder getPortOrBuilder() {
    return getPort();
  }

  public static final int BIND_FIELD_NUMBER = 4;
  private volatile java.lang.Object bind_;
  /**
   * <pre>
   * $hide_from_docs
   * The ip or the Unix domain socket to which the listener should be bound
   * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
   * (Linux abstract namespace). When using Unix domain sockets, the port
   * number should be 0.
   * </pre>
   *
   * <code>string bind = 4;</code>
   * @return The bind.
   */
  public java.lang.String getBind() {
    java.lang.Object ref = bind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bind_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * $hide_from_docs
   * The ip or the Unix domain socket to which the listener should be bound
   * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
   * (Linux abstract namespace). When using Unix domain sockets, the port
   * number should be 0.
   * </pre>
   *
   * <code>string bind = 4;</code>
   * @return The bytes for bind.
   */
  public com.google.protobuf.ByteString
      getBindBytes() {
    java.lang.Object ref = bind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      bind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOSTS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList hosts_;
  /**
   * <pre>
   * REQUIRED. One or more hosts exposed by this gateway.
   * While typically applicable to
   * HTTP services, it can also be used for TCP services using TLS with SNI.
   * A host is specified as a `dnsName` with an optional `namespace/` prefix.
   * The `dnsName` should be specified using FQDN format, optionally including
   * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
   * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
   * specified namespace (e.g.,`prod/&#42;`).
   * The `namespace` can be set to `*` or `.`, representing any or the current
   * namespace, respectively. For example, `*&#47;foo.example.com` selects the
   * service from any available namespace while `./foo.example.com` only selects
   * the service from the namespace of the sidecar. The default, if no `namespace/`
   * is specified, is `*&#47;`, that is, select services from any namespace.
   * Any associated `DestinationRule` in the selected namespace will also be used.
   * A `VirtualService` must be bound to the gateway and must have one or
   * more hosts that match the hosts specified in a server. The match
   * could be an exact match or a suffix match with the server's hosts. For
   * example, if the server's hosts specifies `*.example.com`, a
   * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
   * match. However, a `VirtualService` with host `example.com` or
   * `newexample.com` will not match.
   * NOTE: Only virtual services exported to the gateway's namespace
   * (e.g., `exportTo` value of `*`) can be referenced.
   * Private configurations (e.g., `exportTo` set to `.`) will not be
   * available. Refer to the `exportTo` setting in `VirtualService`,
   * `DestinationRule`, and `ServiceEntry` configurations for details.
   * </pre>
   *
   * <code>repeated string hosts = 2;</code>
   * @return A list containing the hosts.
   */
  public com.google.protobuf.ProtocolStringList
      getHostsList() {
    return hosts_;
  }
  /**
   * <pre>
   * REQUIRED. One or more hosts exposed by this gateway.
   * While typically applicable to
   * HTTP services, it can also be used for TCP services using TLS with SNI.
   * A host is specified as a `dnsName` with an optional `namespace/` prefix.
   * The `dnsName` should be specified using FQDN format, optionally including
   * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
   * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
   * specified namespace (e.g.,`prod/&#42;`).
   * The `namespace` can be set to `*` or `.`, representing any or the current
   * namespace, respectively. For example, `*&#47;foo.example.com` selects the
   * service from any available namespace while `./foo.example.com` only selects
   * the service from the namespace of the sidecar. The default, if no `namespace/`
   * is specified, is `*&#47;`, that is, select services from any namespace.
   * Any associated `DestinationRule` in the selected namespace will also be used.
   * A `VirtualService` must be bound to the gateway and must have one or
   * more hosts that match the hosts specified in a server. The match
   * could be an exact match or a suffix match with the server's hosts. For
   * example, if the server's hosts specifies `*.example.com`, a
   * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
   * match. However, a `VirtualService` with host `example.com` or
   * `newexample.com` will not match.
   * NOTE: Only virtual services exported to the gateway's namespace
   * (e.g., `exportTo` value of `*`) can be referenced.
   * Private configurations (e.g., `exportTo` set to `.`) will not be
   * available. Refer to the `exportTo` setting in `VirtualService`,
   * `DestinationRule`, and `ServiceEntry` configurations for details.
   * </pre>
   *
   * <code>repeated string hosts = 2;</code>
   * @return The count of hosts.
   */
  public int getHostsCount() {
    return hosts_.size();
  }
  /**
   * <pre>
   * REQUIRED. One or more hosts exposed by this gateway.
   * While typically applicable to
   * HTTP services, it can also be used for TCP services using TLS with SNI.
   * A host is specified as a `dnsName` with an optional `namespace/` prefix.
   * The `dnsName` should be specified using FQDN format, optionally including
   * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
   * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
   * specified namespace (e.g.,`prod/&#42;`).
   * The `namespace` can be set to `*` or `.`, representing any or the current
   * namespace, respectively. For example, `*&#47;foo.example.com` selects the
   * service from any available namespace while `./foo.example.com` only selects
   * the service from the namespace of the sidecar. The default, if no `namespace/`
   * is specified, is `*&#47;`, that is, select services from any namespace.
   * Any associated `DestinationRule` in the selected namespace will also be used.
   * A `VirtualService` must be bound to the gateway and must have one or
   * more hosts that match the hosts specified in a server. The match
   * could be an exact match or a suffix match with the server's hosts. For
   * example, if the server's hosts specifies `*.example.com`, a
   * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
   * match. However, a `VirtualService` with host `example.com` or
   * `newexample.com` will not match.
   * NOTE: Only virtual services exported to the gateway's namespace
   * (e.g., `exportTo` value of `*`) can be referenced.
   * Private configurations (e.g., `exportTo` set to `.`) will not be
   * available. Refer to the `exportTo` setting in `VirtualService`,
   * `DestinationRule`, and `ServiceEntry` configurations for details.
   * </pre>
   *
   * <code>repeated string hosts = 2;</code>
   * @param index The index of the element to return.
   * @return The hosts at the given index.
   */
  public java.lang.String getHosts(int index) {
    return hosts_.get(index);
  }
  /**
   * <pre>
   * REQUIRED. One or more hosts exposed by this gateway.
   * While typically applicable to
   * HTTP services, it can also be used for TCP services using TLS with SNI.
   * A host is specified as a `dnsName` with an optional `namespace/` prefix.
   * The `dnsName` should be specified using FQDN format, optionally including
   * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
   * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
   * specified namespace (e.g.,`prod/&#42;`).
   * The `namespace` can be set to `*` or `.`, representing any or the current
   * namespace, respectively. For example, `*&#47;foo.example.com` selects the
   * service from any available namespace while `./foo.example.com` only selects
   * the service from the namespace of the sidecar. The default, if no `namespace/`
   * is specified, is `*&#47;`, that is, select services from any namespace.
   * Any associated `DestinationRule` in the selected namespace will also be used.
   * A `VirtualService` must be bound to the gateway and must have one or
   * more hosts that match the hosts specified in a server. The match
   * could be an exact match or a suffix match with the server's hosts. For
   * example, if the server's hosts specifies `*.example.com`, a
   * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
   * match. However, a `VirtualService` with host `example.com` or
   * `newexample.com` will not match.
   * NOTE: Only virtual services exported to the gateway's namespace
   * (e.g., `exportTo` value of `*`) can be referenced.
   * Private configurations (e.g., `exportTo` set to `.`) will not be
   * available. Refer to the `exportTo` setting in `VirtualService`,
   * `DestinationRule`, and `ServiceEntry` configurations for details.
   * </pre>
   *
   * <code>repeated string hosts = 2;</code>
   * @param index The index of the value to return.
   * @return The bytes of the hosts at the given index.
   */
  public com.google.protobuf.ByteString
      getHostsBytes(int index) {
    return hosts_.getByteString(index);
  }

  public static final int TLS_FIELD_NUMBER = 3;
  private com.alibaba.nacos.istio.model.Server.TLSOptions tls_;
  /**
   * <pre>
   * Set of TLS related options that govern the server's behavior. Use
   * these options to control if all http requests should be redirected to
   * https, and the TLS modes to use.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
   * @return Whether the tls field is set.
   */
  public boolean hasTls() {
    return tls_ != null;
  }
  /**
   * <pre>
   * Set of TLS related options that govern the server's behavior. Use
   * these options to control if all http requests should be redirected to
   * https, and the TLS modes to use.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
   * @return The tls.
   */
  public com.alibaba.nacos.istio.model.Server.TLSOptions getTls() {
    return tls_ == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.getDefaultInstance() : tls_;
  }
  /**
   * <pre>
   * Set of TLS related options that govern the server's behavior. Use
   * these options to control if all http requests should be redirected to
   * https, and the TLS modes to use.
   * </pre>
   *
   * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
   */
  public com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder getTlsOrBuilder() {
    return getTls();
  }

  public static final int DEFAULT_ENDPOINT_FIELD_NUMBER = 5;
  private volatile java.lang.Object defaultEndpoint_;
  /**
   * <pre>
   * The loopback IP endpoint or Unix domain socket to which traffic should
   * be forwarded to by default. Format should be `127.0.0.1:PORT` or
   * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
   * </pre>
   *
   * <code>string default_endpoint = 5;</code>
   * @return The defaultEndpoint.
   */
  public java.lang.String getDefaultEndpoint() {
    java.lang.Object ref = defaultEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultEndpoint_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The loopback IP endpoint or Unix domain socket to which traffic should
   * be forwarded to by default. Format should be `127.0.0.1:PORT` or
   * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
   * </pre>
   *
   * <code>string default_endpoint = 5;</code>
   * @return The bytes for defaultEndpoint.
   */
  public com.google.protobuf.ByteString
      getDefaultEndpointBytes() {
    java.lang.Object ref = defaultEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      defaultEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (port_ != null) {
      output.writeMessage(1, getPort());
    }
    for (int i = 0; i < hosts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, hosts_.getRaw(i));
    }
    if (tls_ != null) {
      output.writeMessage(3, getTls());
    }
    if (!getBindBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, bind_);
    }
    if (!getDefaultEndpointBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, defaultEndpoint_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (port_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getPort());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < hosts_.size(); i++) {
        dataSize += computeStringSizeNoTag(hosts_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getHostsList().size();
    }
    if (tls_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getTls());
    }
    if (!getBindBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, bind_);
    }
    if (!getDefaultEndpointBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, defaultEndpoint_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.alibaba.nacos.istio.model.Server)) {
      return super.equals(obj);
    }
    com.alibaba.nacos.istio.model.Server other = (com.alibaba.nacos.istio.model.Server) obj;

    if (hasPort() != other.hasPort()) return false;
    if (hasPort()) {
      if (!getPort()
          .equals(other.getPort())) return false;
    }
    if (!getBind()
        .equals(other.getBind())) return false;
    if (!getHostsList()
        .equals(other.getHostsList())) return false;
    if (hasTls() != other.hasTls()) return false;
    if (hasTls()) {
      if (!getTls()
          .equals(other.getTls())) return false;
    }
    if (!getDefaultEndpoint()
        .equals(other.getDefaultEndpoint())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPort()) {
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort().hashCode();
    }
    hash = (37 * hash) + BIND_FIELD_NUMBER;
    hash = (53 * hash) + getBind().hashCode();
    if (getHostsCount() > 0) {
      hash = (37 * hash) + HOSTS_FIELD_NUMBER;
      hash = (53 * hash) + getHostsList().hashCode();
    }
    if (hasTls()) {
      hash = (37 * hash) + TLS_FIELD_NUMBER;
      hash = (53 * hash) + getTls().hashCode();
    }
    hash = (37 * hash) + DEFAULT_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultEndpoint().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.alibaba.nacos.istio.model.Server parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.alibaba.nacos.istio.model.Server parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.alibaba.nacos.istio.model.Server parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.alibaba.nacos.istio.model.Server parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.alibaba.nacos.istio.model.Server prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `Server` describes the properties of the proxy on a given load balancer
   * port. For example,
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: Gateway
   * metadata:
   *   name: my-ingress
   * spec:
   *   selector:
   *     app: my-ingress-gateway
   *   servers:
   *   - port:
   *       number: 80
   *       name: http2
   *       protocol: HTTP2
   *     hosts:
   *     - "*"
   * ```
   * Another example
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: Gateway
   * metadata:
   *   name: my-tcp-ingress
   * spec:
   *   selector:
   *     app: my-tcp-ingress-gateway
   *   servers:
   *   - port:
   *       number: 27018
   *       name: mongo
   *       protocol: MONGO
   *     hosts:
   *     - "*"
   * ```
   * The following is an example of TLS configuration for port 443
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: Gateway
   * metadata:
   *   name: my-tls-ingress
   * spec:
   *   selector:
   *     app: my-tls-ingress-gateway
   *   servers:
   *   - port:
   *       number: 443
   *       name: https
   *       protocol: HTTPS
   *     hosts:
   *     - "*"
   *     tls:
   *       mode: SIMPLE
   *       serverCertificate: /etc/certs/server.pem
   *       privateKey: /etc/certs/privatekey.pem
   * ```
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.Server}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Server)
      com.alibaba.nacos.istio.model.ServerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.alibaba.nacos.istio.model.Server.class, com.alibaba.nacos.istio.model.Server.Builder.class);
    }

    // Construct using com.alibaba.nacos.istio.model.Server.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (portBuilder_ == null) {
        port_ = null;
      } else {
        port_ = null;
        portBuilder_ = null;
      }
      bind_ = "";

      hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (tlsBuilder_ == null) {
        tls_ = null;
      } else {
        tls_ = null;
        tlsBuilder_ = null;
      }
      defaultEndpoint_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.alibaba.nacos.istio.model.GatewayOuterClass.internal_static_istio_networking_v1alpha3_Server_descriptor;
    }

    @java.lang.Override
    public com.alibaba.nacos.istio.model.Server getDefaultInstanceForType() {
      return com.alibaba.nacos.istio.model.Server.getDefaultInstance();
    }

    @java.lang.Override
    public com.alibaba.nacos.istio.model.Server build() {
      com.alibaba.nacos.istio.model.Server result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.alibaba.nacos.istio.model.Server buildPartial() {
      com.alibaba.nacos.istio.model.Server result = new com.alibaba.nacos.istio.model.Server(this);
      int from_bitField0_ = bitField0_;
      if (portBuilder_ == null) {
        result.port_ = port_;
      } else {
        result.port_ = portBuilder_.build();
      }
      result.bind_ = bind_;
      if (((bitField0_ & 0x00000001) != 0)) {
        hosts_ = hosts_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.hosts_ = hosts_;
      if (tlsBuilder_ == null) {
        result.tls_ = tls_;
      } else {
        result.tls_ = tlsBuilder_.build();
      }
      result.defaultEndpoint_ = defaultEndpoint_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.alibaba.nacos.istio.model.Server) {
        return mergeFrom((com.alibaba.nacos.istio.model.Server)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.alibaba.nacos.istio.model.Server other) {
      if (other == com.alibaba.nacos.istio.model.Server.getDefaultInstance()) return this;
      if (other.hasPort()) {
        mergePort(other.getPort());
      }
      if (!other.getBind().isEmpty()) {
        bind_ = other.bind_;
        onChanged();
      }
      if (!other.hosts_.isEmpty()) {
        if (hosts_.isEmpty()) {
          hosts_ = other.hosts_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureHostsIsMutable();
          hosts_.addAll(other.hosts_);
        }
        onChanged();
      }
      if (other.hasTls()) {
        mergeTls(other.getTls());
      }
      if (!other.getDefaultEndpoint().isEmpty()) {
        defaultEndpoint_ = other.defaultEndpoint_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.alibaba.nacos.istio.model.Server parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.alibaba.nacos.istio.model.Server) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.alibaba.nacos.istio.model.Port port_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.alibaba.nacos.istio.model.Port, com.alibaba.nacos.istio.model.Port.Builder, com.alibaba.nacos.istio.model.PortOrBuilder> portBuilder_;
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     * @return Whether the port field is set.
     */
    public boolean hasPort() {
      return portBuilder_ != null || port_ != null;
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     * @return The port.
     */
    public com.alibaba.nacos.istio.model.Port getPort() {
      if (portBuilder_ == null) {
        return port_ == null ? com.alibaba.nacos.istio.model.Port.getDefaultInstance() : port_;
      } else {
        return portBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public Builder setPort(com.alibaba.nacos.istio.model.Port value) {
      if (portBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        port_ = value;
        onChanged();
      } else {
        portBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public Builder setPort(
        com.alibaba.nacos.istio.model.Port.Builder builderForValue) {
      if (portBuilder_ == null) {
        port_ = builderForValue.build();
        onChanged();
      } else {
        portBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public Builder mergePort(com.alibaba.nacos.istio.model.Port value) {
      if (portBuilder_ == null) {
        if (port_ != null) {
          port_ =
            com.alibaba.nacos.istio.model.Port.newBuilder(port_).mergeFrom(value).buildPartial();
        } else {
          port_ = value;
        }
        onChanged();
      } else {
        portBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public Builder clearPort() {
      if (portBuilder_ == null) {
        port_ = null;
        onChanged();
      } else {
        port_ = null;
        portBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public com.alibaba.nacos.istio.model.Port.Builder getPortBuilder() {
      
      onChanged();
      return getPortFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    public com.alibaba.nacos.istio.model.PortOrBuilder getPortOrBuilder() {
      if (portBuilder_ != null) {
        return portBuilder_.getMessageOrBuilder();
      } else {
        return port_ == null ?
            com.alibaba.nacos.istio.model.Port.getDefaultInstance() : port_;
      }
    }
    /**
     * <pre>
     * REQUIRED: The Port on which the proxy should listen for incoming
     * connections.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Port port = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.alibaba.nacos.istio.model.Port, com.alibaba.nacos.istio.model.Port.Builder, com.alibaba.nacos.istio.model.PortOrBuilder> 
        getPortFieldBuilder() {
      if (portBuilder_ == null) {
        portBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.alibaba.nacos.istio.model.Port, com.alibaba.nacos.istio.model.Port.Builder, com.alibaba.nacos.istio.model.PortOrBuilder>(
                getPort(),
                getParentForChildren(),
                isClean());
        port_ = null;
      }
      return portBuilder_;
    }

    private java.lang.Object bind_ = "";
    /**
     * <pre>
     * $hide_from_docs
     * The ip or the Unix domain socket to which the listener should be bound
     * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
     * (Linux abstract namespace). When using Unix domain sockets, the port
     * number should be 0.
     * </pre>
     *
     * <code>string bind = 4;</code>
     * @return The bind.
     */
    public java.lang.String getBind() {
      java.lang.Object ref = bind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * $hide_from_docs
     * The ip or the Unix domain socket to which the listener should be bound
     * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
     * (Linux abstract namespace). When using Unix domain sockets, the port
     * number should be 0.
     * </pre>
     *
     * <code>string bind = 4;</code>
     * @return The bytes for bind.
     */
    public com.google.protobuf.ByteString
        getBindBytes() {
      java.lang.Object ref = bind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        bind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * $hide_from_docs
     * The ip or the Unix domain socket to which the listener should be bound
     * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
     * (Linux abstract namespace). When using Unix domain sockets, the port
     * number should be 0.
     * </pre>
     *
     * <code>string bind = 4;</code>
     * @param value The bind to set.
     * @return This builder for chaining.
     */
    public Builder setBind(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      bind_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * $hide_from_docs
     * The ip or the Unix domain socket to which the listener should be bound
     * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
     * (Linux abstract namespace). When using Unix domain sockets, the port
     * number should be 0.
     * </pre>
     *
     * <code>string bind = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearBind() {
      
      bind_ = getDefaultInstance().getBind();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * $hide_from_docs
     * The ip or the Unix domain socket to which the listener should be bound
     * to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://&#64;foobar`
     * (Linux abstract namespace). When using Unix domain sockets, the port
     * number should be 0.
     * </pre>
     *
     * <code>string bind = 4;</code>
     * @param value The bytes for bind to set.
     * @return This builder for chaining.
     */
    public Builder setBindBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      bind_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureHostsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        hosts_ = new com.google.protobuf.LazyStringArrayList(hosts_);
        bitField0_ |= 0x00000001;
       }
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @return A list containing the hosts.
     */
    public com.google.protobuf.ProtocolStringList
        getHostsList() {
      return hosts_.getUnmodifiableView();
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @return The count of hosts.
     */
    public int getHostsCount() {
      return hosts_.size();
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param index The index of the element to return.
     * @return The hosts at the given index.
     */
    public java.lang.String getHosts(int index) {
      return hosts_.get(index);
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the hosts at the given index.
     */
    public com.google.protobuf.ByteString
        getHostsBytes(int index) {
      return hosts_.getByteString(index);
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param index The index to set the value at.
     * @param value The hosts to set.
     * @return This builder for chaining.
     */
    public Builder setHosts(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureHostsIsMutable();
      hosts_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param value The hosts to add.
     * @return This builder for chaining.
     */
    public Builder addHosts(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureHostsIsMutable();
      hosts_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param values The hosts to add.
     * @return This builder for chaining.
     */
    public Builder addAllHosts(
        java.lang.Iterable<java.lang.String> values) {
      ensureHostsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, hosts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearHosts() {
      hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * REQUIRED. One or more hosts exposed by this gateway.
     * While typically applicable to
     * HTTP services, it can also be used for TCP services using TLS with SNI.
     * A host is specified as a `dnsName` with an optional `namespace/` prefix.
     * The `dnsName` should be specified using FQDN format, optionally including
     * a wildcard character in the left-most component (e.g., `prod/&#42;.example.com`).
     * Set the `dnsName` to `*` to select all `VirtualService` hosts from the
     * specified namespace (e.g.,`prod/&#42;`).
     * The `namespace` can be set to `*` or `.`, representing any or the current
     * namespace, respectively. For example, `*&#47;foo.example.com` selects the
     * service from any available namespace while `./foo.example.com` only selects
     * the service from the namespace of the sidecar. The default, if no `namespace/`
     * is specified, is `*&#47;`, that is, select services from any namespace.
     * Any associated `DestinationRule` in the selected namespace will also be used.
     * A `VirtualService` must be bound to the gateway and must have one or
     * more hosts that match the hosts specified in a server. The match
     * could be an exact match or a suffix match with the server's hosts. For
     * example, if the server's hosts specifies `*.example.com`, a
     * `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
     * match. However, a `VirtualService` with host `example.com` or
     * `newexample.com` will not match.
     * NOTE: Only virtual services exported to the gateway's namespace
     * (e.g., `exportTo` value of `*`) can be referenced.
     * Private configurations (e.g., `exportTo` set to `.`) will not be
     * available. Refer to the `exportTo` setting in `VirtualService`,
     * `DestinationRule`, and `ServiceEntry` configurations for details.
     * </pre>
     *
     * <code>repeated string hosts = 2;</code>
     * @param value The bytes of the hosts to add.
     * @return This builder for chaining.
     */
    public Builder addHostsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureHostsIsMutable();
      hosts_.add(value);
      onChanged();
      return this;
    }

    private com.alibaba.nacos.istio.model.Server.TLSOptions tls_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.alibaba.nacos.istio.model.Server.TLSOptions, com.alibaba.nacos.istio.model.Server.TLSOptions.Builder, com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder> tlsBuilder_;
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     * @return Whether the tls field is set.
     */
    public boolean hasTls() {
      return tlsBuilder_ != null || tls_ != null;
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     * @return The tls.
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptions getTls() {
      if (tlsBuilder_ == null) {
        return tls_ == null ? com.alibaba.nacos.istio.model.Server.TLSOptions.getDefaultInstance() : tls_;
      } else {
        return tlsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public Builder setTls(com.alibaba.nacos.istio.model.Server.TLSOptions value) {
      if (tlsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tls_ = value;
        onChanged();
      } else {
        tlsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public Builder setTls(
        com.alibaba.nacos.istio.model.Server.TLSOptions.Builder builderForValue) {
      if (tlsBuilder_ == null) {
        tls_ = builderForValue.build();
        onChanged();
      } else {
        tlsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public Builder mergeTls(com.alibaba.nacos.istio.model.Server.TLSOptions value) {
      if (tlsBuilder_ == null) {
        if (tls_ != null) {
          tls_ =
            com.alibaba.nacos.istio.model.Server.TLSOptions.newBuilder(tls_).mergeFrom(value).buildPartial();
        } else {
          tls_ = value;
        }
        onChanged();
      } else {
        tlsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public Builder clearTls() {
      if (tlsBuilder_ == null) {
        tls_ = null;
        onChanged();
      } else {
        tls_ = null;
        tlsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptions.Builder getTlsBuilder() {
      
      onChanged();
      return getTlsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    public com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder getTlsOrBuilder() {
      if (tlsBuilder_ != null) {
        return tlsBuilder_.getMessageOrBuilder();
      } else {
        return tls_ == null ?
            com.alibaba.nacos.istio.model.Server.TLSOptions.getDefaultInstance() : tls_;
      }
    }
    /**
     * <pre>
     * Set of TLS related options that govern the server's behavior. Use
     * these options to control if all http requests should be redirected to
     * https, and the TLS modes to use.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Server.TLSOptions tls = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.alibaba.nacos.istio.model.Server.TLSOptions, com.alibaba.nacos.istio.model.Server.TLSOptions.Builder, com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder> 
        getTlsFieldBuilder() {
      if (tlsBuilder_ == null) {
        tlsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.alibaba.nacos.istio.model.Server.TLSOptions, com.alibaba.nacos.istio.model.Server.TLSOptions.Builder, com.alibaba.nacos.istio.model.Server.TLSOptionsOrBuilder>(
                getTls(),
                getParentForChildren(),
                isClean());
        tls_ = null;
      }
      return tlsBuilder_;
    }

    private java.lang.Object defaultEndpoint_ = "";
    /**
     * <pre>
     * The loopback IP endpoint or Unix domain socket to which traffic should
     * be forwarded to by default. Format should be `127.0.0.1:PORT` or
     * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
     * </pre>
     *
     * <code>string default_endpoint = 5;</code>
     * @return The defaultEndpoint.
     */
    public java.lang.String getDefaultEndpoint() {
      java.lang.Object ref = defaultEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The loopback IP endpoint or Unix domain socket to which traffic should
     * be forwarded to by default. Format should be `127.0.0.1:PORT` or
     * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
     * </pre>
     *
     * <code>string default_endpoint = 5;</code>
     * @return The bytes for defaultEndpoint.
     */
    public com.google.protobuf.ByteString
        getDefaultEndpointBytes() {
      java.lang.Object ref = defaultEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The loopback IP endpoint or Unix domain socket to which traffic should
     * be forwarded to by default. Format should be `127.0.0.1:PORT` or
     * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
     * </pre>
     *
     * <code>string default_endpoint = 5;</code>
     * @param value The defaultEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultEndpoint(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      defaultEndpoint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The loopback IP endpoint or Unix domain socket to which traffic should
     * be forwarded to by default. Format should be `127.0.0.1:PORT` or
     * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
     * </pre>
     *
     * <code>string default_endpoint = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearDefaultEndpoint() {
      
      defaultEndpoint_ = getDefaultInstance().getDefaultEndpoint();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The loopback IP endpoint or Unix domain socket to which traffic should
     * be forwarded to by default. Format should be `127.0.0.1:PORT` or
     * `unix:///path/to/socket` or `unix://&#64;foobar` (Linux abstract namespace).
     * </pre>
     *
     * <code>string default_endpoint = 5;</code>
     * @param value The bytes for defaultEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultEndpointBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      defaultEndpoint_ = value;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Server)
  }

  // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Server)
  private static final com.alibaba.nacos.istio.model.Server DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.alibaba.nacos.istio.model.Server();
  }

  public static com.alibaba.nacos.istio.model.Server getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Server>
      PARSER = new com.google.protobuf.AbstractParser<Server>() {
    @java.lang.Override
    public Server parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Server(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Server> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Server> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.alibaba.nacos.istio.model.Server getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

