/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.boot.autoconfigure;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.io.VFS;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SpringBootVFS
extends VFS {
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

    public boolean isValid() {
        return true;
    }

    protected List<String> list(URL url, String path) throws IOException {
        String urlString = url.toString();
        String baseUrlString = urlString.endsWith("/") ? urlString : urlString.concat("/");
        Resource[] resources = this.resourceResolver.getResources(baseUrlString + "**/*.class");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (Resource resource : resources) {
            resourcePaths.add(SpringBootVFS.preserveSubpackageName(baseUrlString, resource, path));
        }
        return resourcePaths;
    }

    private static String preserveSubpackageName(String baseUrlString, Resource resource, String rootPath) throws IOException {
        return rootPath + (rootPath.endsWith("/") ? "" : "/") + resource.getURL().toString().substring(baseUrlString.length());
    }
}

