/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory.conf;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.memory.enums.MirroringPolicy;
import org.nd4j.linalg.api.memory.enums.ResetPolicy;
import org.nd4j.linalg.api.memory.enums.SpillPolicy;

public class WorkspaceConfiguration
implements Serializable {
    protected AllocationPolicy policyAllocation;
    protected SpillPolicy policySpill;
    protected MirroringPolicy policyMirroring;
    protected LearningPolicy policyLearning;
    protected ResetPolicy policyReset;
    protected long initialSize;
    protected long minSize;
    protected long maxSize;
    protected int cyclesBeforeInitialization;
    protected double overallocationLimit;
    protected int stepsNumber;

    public static WorkspaceConfigurationBuilder builder() {
        return new WorkspaceConfigurationBuilder();
    }

    public AllocationPolicy getPolicyAllocation() {
        return this.policyAllocation;
    }

    public SpillPolicy getPolicySpill() {
        return this.policySpill;
    }

    public MirroringPolicy getPolicyMirroring() {
        return this.policyMirroring;
    }

    public LearningPolicy getPolicyLearning() {
        return this.policyLearning;
    }

    public ResetPolicy getPolicyReset() {
        return this.policyReset;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getCyclesBeforeInitialization() {
        return this.cyclesBeforeInitialization;
    }

    public double getOverallocationLimit() {
        return this.overallocationLimit;
    }

    public int getStepsNumber() {
        return this.stepsNumber;
    }

    public void setPolicyAllocation(AllocationPolicy policyAllocation) {
        this.policyAllocation = policyAllocation;
    }

    public void setPolicySpill(SpillPolicy policySpill) {
        this.policySpill = policySpill;
    }

    public void setPolicyMirroring(MirroringPolicy policyMirroring) {
        this.policyMirroring = policyMirroring;
    }

    public void setPolicyLearning(LearningPolicy policyLearning) {
        this.policyLearning = policyLearning;
    }

    public void setPolicyReset(ResetPolicy policyReset) {
        this.policyReset = policyReset;
    }

    public void setInitialSize(long initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinSize(long minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setCyclesBeforeInitialization(int cyclesBeforeInitialization) {
        this.cyclesBeforeInitialization = cyclesBeforeInitialization;
    }

    public void setOverallocationLimit(double overallocationLimit) {
        this.overallocationLimit = overallocationLimit;
    }

    public void setStepsNumber(int stepsNumber) {
        this.stepsNumber = stepsNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkspaceConfiguration)) {
            return false;
        }
        WorkspaceConfiguration other = (WorkspaceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AllocationPolicy this$policyAllocation = this.getPolicyAllocation();
        AllocationPolicy other$policyAllocation = other.getPolicyAllocation();
        if (this$policyAllocation == null ? other$policyAllocation != null : !((Object)((Object)this$policyAllocation)).equals((Object)other$policyAllocation)) {
            return false;
        }
        SpillPolicy this$policySpill = this.getPolicySpill();
        SpillPolicy other$policySpill = other.getPolicySpill();
        if (this$policySpill == null ? other$policySpill != null : !((Object)((Object)this$policySpill)).equals((Object)other$policySpill)) {
            return false;
        }
        MirroringPolicy this$policyMirroring = this.getPolicyMirroring();
        MirroringPolicy other$policyMirroring = other.getPolicyMirroring();
        if (this$policyMirroring == null ? other$policyMirroring != null : !((Object)((Object)this$policyMirroring)).equals((Object)other$policyMirroring)) {
            return false;
        }
        LearningPolicy this$policyLearning = this.getPolicyLearning();
        LearningPolicy other$policyLearning = other.getPolicyLearning();
        if (this$policyLearning == null ? other$policyLearning != null : !((Object)((Object)this$policyLearning)).equals((Object)other$policyLearning)) {
            return false;
        }
        ResetPolicy this$policyReset = this.getPolicyReset();
        ResetPolicy other$policyReset = other.getPolicyReset();
        if (this$policyReset == null ? other$policyReset != null : !((Object)((Object)this$policyReset)).equals((Object)other$policyReset)) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getCyclesBeforeInitialization() != other.getCyclesBeforeInitialization()) {
            return false;
        }
        if (Double.compare(this.getOverallocationLimit(), other.getOverallocationLimit()) != 0) {
            return false;
        }
        return this.getStepsNumber() == other.getStepsNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkspaceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AllocationPolicy $policyAllocation = this.getPolicyAllocation();
        result = result * 59 + ($policyAllocation == null ? 43 : ((Object)((Object)$policyAllocation)).hashCode());
        SpillPolicy $policySpill = this.getPolicySpill();
        result = result * 59 + ($policySpill == null ? 43 : ((Object)((Object)$policySpill)).hashCode());
        MirroringPolicy $policyMirroring = this.getPolicyMirroring();
        result = result * 59 + ($policyMirroring == null ? 43 : ((Object)((Object)$policyMirroring)).hashCode());
        LearningPolicy $policyLearning = this.getPolicyLearning();
        result = result * 59 + ($policyLearning == null ? 43 : ((Object)((Object)$policyLearning)).hashCode());
        ResetPolicy $policyReset = this.getPolicyReset();
        result = result * 59 + ($policyReset == null ? 43 : ((Object)((Object)$policyReset)).hashCode());
        long $initialSize = this.getInitialSize();
        result = result * 59 + (int)($initialSize >>> 32 ^ $initialSize);
        long $minSize = this.getMinSize();
        result = result * 59 + (int)($minSize >>> 32 ^ $minSize);
        long $maxSize = this.getMaxSize();
        result = result * 59 + (int)($maxSize >>> 32 ^ $maxSize);
        result = result * 59 + this.getCyclesBeforeInitialization();
        long $overallocationLimit = Double.doubleToLongBits(this.getOverallocationLimit());
        result = result * 59 + (int)($overallocationLimit >>> 32 ^ $overallocationLimit);
        result = result * 59 + this.getStepsNumber();
        return result;
    }

    public String toString() {
        return "WorkspaceConfiguration(policyAllocation=" + (Object)((Object)this.getPolicyAllocation()) + ", policySpill=" + (Object)((Object)this.getPolicySpill()) + ", policyMirroring=" + (Object)((Object)this.getPolicyMirroring()) + ", policyLearning=" + (Object)((Object)this.getPolicyLearning()) + ", policyReset=" + (Object)((Object)this.getPolicyReset()) + ", initialSize=" + this.getInitialSize() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", cyclesBeforeInitialization=" + this.getCyclesBeforeInitialization() + ", overallocationLimit=" + this.getOverallocationLimit() + ", stepsNumber=" + this.getStepsNumber() + ")";
    }

    public WorkspaceConfiguration() {
    }

    @ConstructorProperties(value={"policyAllocation", "policySpill", "policyMirroring", "policyLearning", "policyReset", "initialSize", "minSize", "maxSize", "cyclesBeforeInitialization", "overallocationLimit", "stepsNumber"})
    public WorkspaceConfiguration(AllocationPolicy policyAllocation, SpillPolicy policySpill, MirroringPolicy policyMirroring, LearningPolicy policyLearning, ResetPolicy policyReset, long initialSize, long minSize, long maxSize, int cyclesBeforeInitialization, double overallocationLimit, int stepsNumber) {
        this.policyAllocation = policyAllocation;
        this.policySpill = policySpill;
        this.policyMirroring = policyMirroring;
        this.policyLearning = policyLearning;
        this.policyReset = policyReset;
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.cyclesBeforeInitialization = cyclesBeforeInitialization;
        this.overallocationLimit = overallocationLimit;
        this.stepsNumber = stepsNumber;
    }

    public static class WorkspaceConfigurationBuilder {
        private AllocationPolicy policyAllocation = AllocationPolicy.OVERALLOCATE;
        private SpillPolicy policySpill = SpillPolicy.EXTERNAL;
        private MirroringPolicy policyMirroring = MirroringPolicy.FULL;
        private LearningPolicy policyLearning = LearningPolicy.FIRST_LOOP;
        private ResetPolicy policyReset = ResetPolicy.BLOCK_LEFT;
        private long initialSize = 0L;
        private long minSize = 0L;
        private long maxSize = 0L;
        protected int cyclesBeforeInitialization = 0;
        private double overallocationLimit = 0.3;
        private int stepsNumber = 2;

        WorkspaceConfigurationBuilder() {
        }

        public WorkspaceConfigurationBuilder policyAllocation(AllocationPolicy policyAllocation) {
            this.policyAllocation = policyAllocation;
            return this;
        }

        public WorkspaceConfigurationBuilder policySpill(SpillPolicy policySpill) {
            this.policySpill = policySpill;
            return this;
        }

        public WorkspaceConfigurationBuilder policyMirroring(MirroringPolicy policyMirroring) {
            this.policyMirroring = policyMirroring;
            return this;
        }

        public WorkspaceConfigurationBuilder policyLearning(LearningPolicy policyLearning) {
            this.policyLearning = policyLearning;
            return this;
        }

        public WorkspaceConfigurationBuilder policyReset(ResetPolicy policyReset) {
            this.policyReset = policyReset;
            return this;
        }

        public WorkspaceConfigurationBuilder initialSize(long initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public WorkspaceConfigurationBuilder minSize(long minSize) {
            this.minSize = minSize;
            return this;
        }

        public WorkspaceConfigurationBuilder maxSize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public WorkspaceConfigurationBuilder cyclesBeforeInitialization(int cyclesBeforeInitialization) {
            this.cyclesBeforeInitialization = cyclesBeforeInitialization;
            return this;
        }

        public WorkspaceConfigurationBuilder overallocationLimit(double overallocationLimit) {
            this.overallocationLimit = overallocationLimit;
            return this;
        }

        public WorkspaceConfigurationBuilder stepsNumber(int stepsNumber) {
            this.stepsNumber = stepsNumber;
            return this;
        }

        public WorkspaceConfiguration build() {
            return new WorkspaceConfiguration(this.policyAllocation, this.policySpill, this.policyMirroring, this.policyLearning, this.policyReset, this.initialSize, this.minSize, this.maxSize, this.cyclesBeforeInitialization, this.overallocationLimit, this.stepsNumber);
        }

        public String toString() {
            return "WorkspaceConfiguration.WorkspaceConfigurationBuilder(policyAllocation=" + (Object)((Object)this.policyAllocation) + ", policySpill=" + (Object)((Object)this.policySpill) + ", policyMirroring=" + (Object)((Object)this.policyMirroring) + ", policyLearning=" + (Object)((Object)this.policyLearning) + ", policyReset=" + (Object)((Object)this.policyReset) + ", initialSize=" + this.initialSize + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", cyclesBeforeInitialization=" + this.cyclesBeforeInitialization + ", overallocationLimit=" + this.overallocationLimit + ", stepsNumber=" + this.stepsNumber + ")";
        }
    }
}

