/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import org.quartz.ExecuteInJTATransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.core.JobRunShellFactory;
import org.quartz.ee.jta.JTAJobRunShell;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.ClassUtils;

public class JTAAnnotationAwareJobRunShellFactory
implements JobRunShellFactory {
    private Scheduler scheduler;

    public void initialize(Scheduler scheduler) throws SchedulerConfigException {
        this.scheduler = scheduler;
    }

    public JobRunShell createJobRunShell(TriggerFiredBundle bundle) throws SchedulerException {
        boolean needsJTA = ClassUtils.isAnnotationPresent(bundle.getJobDetail().getJobClass(), ExecuteInJTATransaction.class);
        if (needsJTA) {
            return new JTAJobRunShell(this.scheduler, bundle);
        }
        return new JobRunShell(this.scheduler, bundle);
    }
}

