/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;

public class BuildInfoProperties
implements Serializable {
    private final transient Project project;
    private String group;
    private String artifact;
    private String version;
    private String name;
    private Instant time;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    BuildInfoProperties(Project project) {
        this.project = project;
        this.time = Instant.now();
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.project.getGroup().toString();
        }
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.project.getVersion().toString();
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.project.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public Map<String, Object> getAdditional() {
        return this.additionalProperties;
    }

    public void setAdditional(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuildInfoProperties other = (BuildInfoProperties)obj;
        boolean result = true;
        result = result && this.nullSafeEquals(this.additionalProperties, other.additionalProperties);
        result = result && this.nullSafeEquals(this.artifact, other.artifact);
        result = result && this.nullSafeEquals(this.group, other.group);
        result = result && this.nullSafeEquals(this.name, other.name);
        result = result && this.nullSafeEquals(this.version, other.version);
        result = result && this.nullSafeEquals(this.time, other.time);
        return result;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }
}

