/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.springframework.boot.gradle.tasks.bundling.LayeredSpec;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCoordinates;

class LayerResolver {
    private final ResolvedDependencies resolvedDependencies;
    private final LayeredSpec layeredConfiguration;
    private final Spec<FileCopyDetails> librarySpec;

    LayerResolver(Iterable<SourceSet> sourceSets, Iterable<Configuration> configurations, LayeredSpec layeredConfiguration, Spec<FileCopyDetails> librarySpec) {
        this.resolvedDependencies = new ResolvedDependencies(sourceSets, configurations);
        this.layeredConfiguration = layeredConfiguration;
        this.librarySpec = librarySpec;
    }

    Layer getLayer(FileCopyDetails details) {
        try {
            if (this.librarySpec.isSatisfiedBy((Object)details)) {
                return this.getLayer(this.asLibrary(details));
            }
            return this.getLayer(details.getSourcePath());
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    Layer getLayer(Library library) {
        return this.layeredConfiguration.asLayers().getLayer(library);
    }

    Layer getLayer(String applicationResource) {
        return this.layeredConfiguration.asLayers().getLayer(applicationResource);
    }

    Iterable<Layer> getLayers() {
        return this.layeredConfiguration.asLayers();
    }

    private Library asLibrary(FileCopyDetails details) {
        File file = details.getFile();
        LibraryCoordinates coordinates = this.resolvedDependencies.find(file);
        return new Library(null, file, null, coordinates, false);
    }

    private static class ModuleVersionIdentifierLibraryCoordinates
    implements LibraryCoordinates {
        private final ModuleVersionIdentifier identifier;

        ModuleVersionIdentifierLibraryCoordinates(ModuleVersionIdentifier identifier) {
            this.identifier = identifier;
        }

        public String getGroupId() {
            return this.identifier.getGroup();
        }

        public String getArtifactId() {
            return this.identifier.getName();
        }

        public String getVersion() {
            return this.identifier.getVersion();
        }

        public String toString() {
            return this.identifier.toString();
        }
    }

    private static class ResolvedConfigurationDependencies {
        private final Map<File, LibraryCoordinates> artifactCoordinates = new LinkedHashMap<File, LibraryCoordinates>();

        ResolvedConfigurationDependencies(ResolvedConfiguration resolvedConfiguration) {
            for (ResolvedArtifact resolvedArtifact : resolvedConfiguration.getResolvedArtifacts()) {
                this.artifactCoordinates.put(resolvedArtifact.getFile(), new ModuleVersionIdentifierLibraryCoordinates(resolvedArtifact.getModuleVersion().getId()));
            }
        }

        LibraryCoordinates find(File file) {
            return this.artifactCoordinates.get(file);
        }
    }

    private static class ResolvedDependencies {
        private final Set<String> deprecatedForResolutionConfigurationNames;
        private final Map<Configuration, ResolvedConfigurationDependencies> configurationDependencies = new LinkedHashMap<Configuration, ResolvedConfigurationDependencies>();

        ResolvedDependencies(Iterable<SourceSet> sourceSets, Iterable<Configuration> configurations) {
            this.deprecatedForResolutionConfigurationNames = this.deprecatedForResolutionConfigurationNames(sourceSets);
            configurations.forEach(this::processConfiguration);
        }

        private Set<String> deprecatedForResolutionConfigurationNames(Iterable<SourceSet> sourceSets) {
            HashSet<String> configurationNames = new HashSet<String>();
            configurationNames.add("archives");
            configurationNames.add("default");
            for (SourceSet sourceSet : sourceSets) {
                try {
                    configurationNames.add(sourceSet.getCompileConfigurationName());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                configurationNames.add(sourceSet.getCompileOnlyConfigurationName());
                try {
                    configurationNames.add(sourceSet.getRuntimeConfigurationName());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            }
            return configurationNames;
        }

        private void processConfiguration(Configuration configuration) {
            if (configuration.isCanBeResolved() && !this.deprecatedForResolutionConfigurationNames.contains(configuration.getName())) {
                this.configurationDependencies.put(configuration, new ResolvedConfigurationDependencies(configuration.getResolvedConfiguration()));
            }
        }

        LibraryCoordinates find(File file) {
            for (ResolvedConfigurationDependencies dependencies : this.configurationDependencies.values()) {
                LibraryCoordinates coordinates = dependencies.find(file);
                if (coordinates == null) continue;
                return coordinates;
            }
            return null;
        }
    }
}

