/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.legacy.context.web;

import java.util.Arrays;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.legacy.context.web.AnnotationConfigNonEmbeddedWebApplicationContext;
import org.springframework.boot.legacy.context.web.servlet.support.ErrorPageFilterConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

public class SpringBootContextLoaderListener
extends ContextLoaderListener {
    public static final String SPRING_BOOT_LEGACY_REGISTER_ERROR_PAGE_FILTER_PARAM = "springBootLegacyRegisterErrorPageFilter";
    private static final String INIT_PARAM_DELIMITERS = ",; \t\n";
    protected Log logger;
    private boolean registerErrorPageFilter = true;

    protected final void setRegisterErrorPageFilter(boolean registerErrorPageFilter) {
        this.registerErrorPageFilter = registerErrorPageFilter;
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        SpringApplication application;
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.logger.debug((Object)"Initializing WebApplicationContext");
        String configLocationParam = servletContext.getInitParameter("contextConfigLocation");
        String[] classNames = StringUtils.tokenizeToStringArray((String)configLocationParam, (String)INIT_PARAM_DELIMITERS);
        this.setRegisterErrorPageFilterFromContextParam(servletContext);
        SpringApplicationBuilder builder = this.createSpringApplicationBuilder(classNames);
        StandardServletEnvironment environment = new StandardServletEnvironment();
        environment.initPropertySources(servletContext, null);
        builder.environment((ConfigurableEnvironment)environment);
        this.setMainClass(builder, classNames);
        Class<?> contextClass = this.determineContextClass(servletContext);
        builder.contextClass(contextClass);
        ApplicationContext parent = this.getExistingRootWebApplicationContext(servletContext);
        if (parent != null) {
            this.logger.info((Object)"Root context already created (using as parent).");
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, null);
            builder.initializers(new ApplicationContextInitializer[]{new ParentContextApplicationContextInitializer(parent)});
        }
        builder.initializers(new ApplicationContextInitializer[]{applicationContext -> applicationContext.setServletContext(servletContext)});
        if (this.registerErrorPageFilter) {
            builder.sources(new Class[]{ErrorPageFilterConfiguration.class});
        }
        if ((application = builder.build()).getAllSources().isEmpty() && AnnotationUtils.findAnnotation(((Object)((Object)this)).getClass(), Configuration.class) != null) {
            application.addPrimarySources(Collections.singleton(((Object)((Object)this)).getClass()));
        }
        Assert.state((!application.getAllSources().isEmpty() ? 1 : 0) != 0, (String)"No SpringApplication sources have been defined. Either override the configure method or add an @Configuration annotation");
        WebApplicationContext context = (WebApplicationContext)application.run(new String[0]);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        return context;
    }

    private void setMainClass(SpringApplicationBuilder builder, String[] classNames) {
        try {
            builder.main(Class.forName(classNames[0]));
        }
        catch (ClassNotFoundException e) {
            this.logger.warn((Object)("Could create instance of class " + classNames[0] + " provided by " + "contextConfigLocation"), (Throwable)e);
        }
    }

    private void setRegisterErrorPageFilterFromContextParam(ServletContext servletContext) {
        String contextParamValue = servletContext.getInitParameter(SPRING_BOOT_LEGACY_REGISTER_ERROR_PAGE_FILTER_PARAM);
        if (contextParamValue == null) {
            this.logger.debug((Object)("No context init parameter found for springBootLegacyRegisterErrorPageFilter; leaving it at default value: " + this.registerErrorPageFilter));
        } else if (StringUtils.hasText((String)contextParamValue)) {
            boolean booleanValue = Boolean.parseBoolean(contextParamValue);
            this.setRegisterErrorPageFilter(booleanValue);
            this.logger.debug((Object)("Found context init parameter found for springBootLegacyRegisterErrorPageFilter; updating registerErrorPageFilter to " + this.registerErrorPageFilter));
        } else {
            this.logger.warn((Object)("Context init parameter found for springBootLegacyRegisterErrorPageFilter but it is empty; leaving it at default value: " + this.registerErrorPageFilter));
        }
    }

    protected SpringApplicationBuilder createSpringApplicationBuilder(String[] classNames) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating SpringApplicationBuilder ( with classes: " + Arrays.toString(classNames) + ")"));
        }
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                classes[i] = ClassUtils.forName((String)classNames[i], null);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationContextException("Failed to load custom context class [" + classNames[i] + "]", (Throwable)e);
            }
        }
        return new SpringApplicationBuilder(classes);
    }

    private ApplicationContext getExistingRootWebApplicationContext(ServletContext servletContext) {
        Object context = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context instanceof ApplicationContext) {
            return (ApplicationContext)context;
        }
        return null;
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        String contextClassName = servletContext.getInitParameter("contextClass");
        if (contextClassName != null) {
            this.logger.info((Object)("Using context class: " + contextClassName));
            try {
                return ClassUtils.forName((String)contextClassName, null);
            }
            catch (Exception e) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)e);
            }
        }
        this.logger.debug((Object)("Using default context class: " + AnnotationConfigNonEmbeddedWebApplicationContext.class.getCanonicalName() + ""));
        return AnnotationConfigNonEmbeddedWebApplicationContext.class;
    }
}

