/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class TestDatabaseAutoConfiguration {
    private final Environment environment;

    TestDatabaseAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="AUTO_CONFIGURED")
    @ConditionalOnMissingBean
    public DataSource dataSource() {
        return new EmbeddedDataSourceFactory(this.environment).getEmbeddedDatabase();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="ANY", matchIfMissing=true)
    public static EmbeddedDataSourceBeanFactoryPostProcessor embeddedDataSourceBeanFactoryPostProcessor() {
        return new EmbeddedDataSourceBeanFactoryPostProcessor();
    }

    private static class EmbeddedDataSourceFactory {
        private final Environment environment;

        EmbeddedDataSourceFactory(Environment environment) {
            this.environment = environment;
        }

        public EmbeddedDatabase getEmbeddedDatabase() {
            EmbeddedDatabaseConnection connection = (EmbeddedDatabaseConnection)this.environment.getProperty("spring.test.database.connection", EmbeddedDatabaseConnection.class, (Object)EmbeddedDatabaseConnection.NONE);
            if (EmbeddedDatabaseConnection.NONE.equals((Object)connection)) {
                connection = EmbeddedDatabaseConnection.get((ClassLoader)this.getClass().getClassLoader());
            }
            Assert.state((connection != EmbeddedDatabaseConnection.NONE ? 1 : 0) != 0, (String)"Failed to replace DataSource with an embedded database for tests. If you want an embedded database please put a supported one on the classpath or tune the replace attribute of @AutoConfigureTestDatabase.");
            return new EmbeddedDatabaseBuilder().generateUniqueName(true).setType(connection.getType()).build();
        }
    }

    private static class EmbeddedDataSourceFactoryBean
    implements FactoryBean<DataSource>,
    EnvironmentAware,
    InitializingBean {
        private EmbeddedDataSourceFactory factory;
        private EmbeddedDatabase embeddedDatabase;

        private EmbeddedDataSourceFactoryBean() {
        }

        public void setEnvironment(Environment environment) {
            this.factory = new EmbeddedDataSourceFactory(environment);
        }

        public void afterPropertiesSet() throws Exception {
            this.embeddedDatabase = this.factory.getEmbeddedDatabase();
        }

        public DataSource getObject() throws Exception {
            return this.embeddedDatabase;
        }

        public Class<?> getObjectType() {
            return EmbeddedDatabase.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Order(value=0x7FFFFFFF)
    private static class EmbeddedDataSourceBeanFactoryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Log logger = LogFactory.getLog(EmbeddedDataSourceBeanFactoryPostProcessor.class);

        private EmbeddedDataSourceBeanFactoryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Test Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            this.process(registry, (ConfigurableListableBeanFactory)registry);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        private void process(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
            BeanDefinitionHolder holder = this.getDataSourceBeanDefinition(beanFactory);
            if (holder != null) {
                String beanName = holder.getBeanName();
                boolean primary = holder.getBeanDefinition().isPrimary();
                logger.info((Object)("Replacing '" + beanName + "' DataSource bean with " + (primary ? "primary " : "") + "embedded version"));
                registry.removeBeanDefinition(beanName);
                registry.registerBeanDefinition(beanName, this.createEmbeddedBeanDefinition(primary));
            }
        }

        private BeanDefinition createEmbeddedBeanDefinition(boolean primary) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(EmbeddedDataSourceFactoryBean.class);
            beanDefinition.setPrimary(primary);
            return beanDefinition;
        }

        private BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
            Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
            if (ObjectUtils.isEmpty((Object[])beanNames)) {
                logger.warn((Object)"No DataSource beans found, embedded version will not be used");
                return null;
            }
            if (beanNames.length == 1) {
                Object beanName = beanNames[0];
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            for (Object beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                if (!beanDefinition.isPrimary()) continue;
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            logger.warn((Object)"No primary DataSource found, embedded version will not be used");
            return null;
        }
    }
}

