/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.app;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.compiler.AbstractFunctionCompiler;
import org.springframework.cloud.function.compiler.CompiledFunctionFactory;
import org.springframework.cloud.function.compiler.ConsumerCompiler;
import org.springframework.cloud.function.compiler.FunctionCompiler;
import org.springframework.cloud.function.compiler.SupplierCompiler;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import reactor.core.publisher.Flux;

public class CompiledFunctionRegistry {
    private static final String SUPPLIER_DIRECTORY = "suppliers";
    private static final String FUNCTION_DIRECTORY = "functions";
    private static final String CONSUMER_DIRECTORY = "consumers";
    private final File supplierDirectory;
    private final File functionDirectory;
    private final File consumerDirectory;
    private final AbstractFunctionCompiler<Supplier<Flux<?>>> supplierCompiler = new SupplierCompiler();
    private final AbstractFunctionCompiler<Function<Flux<?>, Flux<?>>> functionCompiler = new FunctionCompiler();
    private final AbstractFunctionCompiler<Consumer<Flux<?>>> consumerCompiler = new ConsumerCompiler();

    public CompiledFunctionRegistry() {
        this(new File("/tmp/function-registry"));
    }

    public CompiledFunctionRegistry(File directory) {
        Assert.notNull((Object)directory, (String)"Directory must not be null");
        if (!directory.exists()) {
            directory.mkdirs();
        } else {
            Assert.isTrue((boolean)directory.isDirectory(), (String)String.format("%s is not a directory.", directory.getAbsolutePath()));
        }
        this.supplierDirectory = new File(directory, SUPPLIER_DIRECTORY);
        this.functionDirectory = new File(directory, FUNCTION_DIRECTORY);
        this.consumerDirectory = new File(directory, CONSUMER_DIRECTORY);
        this.supplierDirectory.mkdir();
        this.functionDirectory.mkdir();
        this.consumerDirectory.mkdir();
    }

    public void registerSupplier(String name, String lambda, String type) {
        this.doRegister(this.supplierCompiler, this.supplierDirectory, name, lambda, type);
    }

    public void registerFunction(String name, String lambda, String ... types) {
        this.doRegister(this.functionCompiler, this.functionDirectory, name, lambda, types);
    }

    public void registerConsumer(String name, String lambda, String type) {
        this.doRegister(this.consumerCompiler, this.consumerDirectory, name, lambda, type);
    }

    private void doRegister(AbstractFunctionCompiler<?> compiler, File directory, String name, String lambda, String ... types) {
        CompiledFunctionFactory<?> factory = compiler.compile(name, lambda, types);
        File file = new File(directory, this.fileName(name));
        try {
            FileCopyUtils.copy((byte[])factory.getGeneratedClassBytes(), (File)file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("failed to register '%s'", name), e);
        }
    }

    private String fileName(String functionName) {
        return String.format("%s.%s", functionName, "fun");
    }
}

