/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryJavaFileObject
implements JavaFileObject {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryJavaFileObject.class);
    private JavaFileManager.Location location;
    private String packageName;
    private String relativeName;
    private FileObject sibling;
    private String className;
    private JavaFileObject.Kind kind;
    private byte[] content = null;
    private long lastModifiedTime = 0L;
    private URI uri = null;

    private InMemoryJavaFileObject() {
    }

    public static InMemoryJavaFileObject getFileObject(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) {
        InMemoryJavaFileObject retval = new InMemoryJavaFileObject();
        retval.kind = JavaFileObject.Kind.OTHER;
        retval.location = location;
        retval.packageName = packageName;
        retval.relativeName = relativeName;
        retval.sibling = sibling;
        return retval;
    }

    public static InMemoryJavaFileObject getJavaFileObject(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        InMemoryJavaFileObject retval = new InMemoryJavaFileObject();
        retval.location = location;
        retval.className = className;
        retval.kind = kind;
        retval.sibling = sibling;
        return retval;
    }

    public static InMemoryJavaFileObject getSourceJavaFileObject(String className, String content) {
        InMemoryJavaFileObject retval = new InMemoryJavaFileObject();
        retval.location = StandardLocation.SOURCE_PATH;
        retval.className = className;
        retval.kind = JavaFileObject.Kind.SOURCE;
        retval.content = content.getBytes();
        return retval;
    }

    public byte[] getBytes() {
        return this.content;
    }

    public String toString() {
        return "OutputJavaFileObject: Location=" + this.location + ",className=" + this.className + ",kind=" + (Object)((Object)this.kind) + ",relativeName=" + this.relativeName + ",sibling=" + this.sibling + ",packageName=" + this.packageName;
    }

    @Override
    public URI toUri() {
        if (this.uri == null) {
            String name = null;
            name = this.className != null ? this.className.replace('.', '/') : (this.packageName != null && this.packageName.length() != 0 ? this.packageName.replace('.', '/') + '/' + this.relativeName : this.relativeName);
            String uriString = null;
            try {
                uriString = "file:/" + name + this.kind.extension;
                this.uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unexpected URISyntaxException for string '" + uriString + "'", e);
            }
        }
        return this.uri;
    }

    @Override
    public String getName() {
        return this.toUri().getPath();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.content == null) {
            throw new FileNotFoundException();
        }
        logger.debug("opening input stream for {}", (Object)this.getName());
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        logger.debug("opening output stream for {}", (Object)this.getName());
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                InMemoryJavaFileObject.this.lastModifiedTime = System.currentTimeMillis();
                InMemoryJavaFileObject.access$102(InMemoryJavaFileObject.this, this.toByteArray());
            }
        };
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.openInputStream(), Charset.defaultCharset());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.kind != JavaFileObject.Kind.SOURCE) {
            throw new UnsupportedOperationException("getCharContent() not supported on file object: " + this.getName());
        }
        return this.content == null ? null : new String(this.content);
    }

    @Override
    public Writer openWriter() throws IOException {
        return new CharArrayWriter(){

            @Override
            public void close() {
                InMemoryJavaFileObject.this.lastModifiedTime = System.currentTimeMillis();
                InMemoryJavaFileObject.access$102(InMemoryJavaFileObject.this, new String(this.toCharArray()).getBytes());
            }
        };
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedTime;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        String baseName = simpleName + kind.extension;
        return kind.equals((Object)this.getKind()) && (baseName.equals(this.toUri().getPath()) || this.toUri().getPath().endsWith("/" + baseName));
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    static /* synthetic */ byte[] access$102(InMemoryJavaFileObject x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }
}

