/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Routing;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.join.JoinField;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleElasticsearchPersistentEntity<T>
extends BasicPersistentEntity<T, ElasticsearchPersistentProperty>
implements ElasticsearchPersistentEntity<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchPersistentEntity.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    @Nullable
    private final Document document;
    @Nullable
    private String indexName;
    private final Lazy<SettingsParameter> settingsParameter;
    @Nullable
    private ElasticsearchPersistentProperty seqNoPrimaryTermProperty;
    @Nullable
    private ElasticsearchPersistentProperty joinFieldProperty;
    @Nullable
    private Document.VersionType versionType;
    private boolean createIndexAndMapping;
    private final Dynamic dynamic;
    private final Map<String, ElasticsearchPersistentProperty> fieldNamePropertyCache = new ConcurrentHashMap<String, ElasticsearchPersistentProperty>();
    private final ConcurrentHashMap<String, Expression> routingExpressions = new ConcurrentHashMap();
    @Nullable
    private String routing;
    private final ContextConfiguration contextConfiguration;
    private final ConcurrentHashMap<String, Expression> indexNameExpressions = new ConcurrentHashMap();
    private final Lazy<EvaluationContext> indexNameEvaluationContext = Lazy.of(this::getIndexNameEvaluationContext);

    public SimpleElasticsearchPersistentEntity(TypeInformation<T> typeInformation, ContextConfiguration contextConfiguration) {
        super(typeInformation);
        this.contextConfiguration = contextConfiguration;
        Class clazz = typeInformation.getType();
        this.document = (Document)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, Document.class);
        this.settingsParameter = Lazy.of(() -> this.buildSettingsParameter(clazz));
        if (this.document != null) {
            Assert.hasText((String)this.document.indexName(), (String)" Unknown indexName. Make sure the indexName is defined. e.g @Document(indexName=\"foo\")");
            this.indexName = this.document.indexName();
            this.versionType = this.document.versionType();
            this.createIndexAndMapping = this.document.createIndex();
            this.dynamic = this.document.dynamic();
        } else {
            this.dynamic = Dynamic.INHERIT;
        }
        Routing routingAnnotation = (Routing)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, Routing.class);
        if (routingAnnotation != null) {
            Assert.hasText((String)routingAnnotation.value(), (String)"@Routing annotation must contain a non-empty value");
            this.routing = routingAnnotation.value();
        }
    }

    private String getIndexName() {
        return this.indexName != null ? this.indexName : this.getTypeInformation().getType().getSimpleName();
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.resolve(IndexCoordinates.of(this.getIndexName()));
    }

    @Override
    @Nullable
    public String getIndexStoreType() {
        return ((SettingsParameter)this.settingsParameter.get()).indexStoreType;
    }

    @Override
    public short getShards() {
        return ((SettingsParameter)this.settingsParameter.get()).shards;
    }

    @Override
    public short getReplicas() {
        return ((SettingsParameter)this.settingsParameter.get()).replicas;
    }

    @Override
    public boolean isUseServerConfiguration() {
        return ((SettingsParameter)this.settingsParameter.get()).useServerConfiguration;
    }

    @Override
    @Nullable
    public String getRefreshInterval() {
        return ((SettingsParameter)this.settingsParameter.get()).refreshIntervall;
    }

    @Override
    @Nullable
    public Document.VersionType getVersionType() {
        return this.versionType;
    }

    @Override
    public boolean isCreateIndexAndMapping() {
        return this.createIndexAndMapping;
    }

    @Override
    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.contextConfiguration.getFieldNamingStrategy();
    }

    @Override
    public boolean writeTypeHints() {
        boolean writeTypeHints = this.contextConfiguration.getWriteTypeHints();
        if (this.document != null) {
            switch (this.document.writeTypeHint()) {
                case TRUE: {
                    writeTypeHints = true;
                    break;
                }
                case FALSE: {
                    writeTypeHints = false;
                    break;
                }
            }
        }
        return writeTypeHints;
    }

    public void addPersistentProperty(ElasticsearchPersistentProperty property) {
        Class<?> actualType;
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isSeqNoPrimaryTermProperty()) {
            ElasticsearchPersistentProperty seqNoPrimaryTermProperty = this.seqNoPrimaryTermProperty;
            if (seqNoPrimaryTermProperty != null) {
                throw new MappingException(String.format("Attempt to add SeqNoPrimaryTerm property %s but already have property %s registered as SeqNoPrimaryTerm property. Check your entity configuration!", property.getField(), seqNoPrimaryTermProperty.getField()));
            }
            this.seqNoPrimaryTermProperty = property;
            if (this.hasVersionProperty()) {
                this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
            }
        }
        if (property.isVersionProperty() && this.hasSeqNoPrimaryTermProperty()) {
            this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
        }
        if ((actualType = property.getActualTypeOrNull()) == JoinField.class) {
            ElasticsearchPersistentProperty joinProperty = this.joinFieldProperty;
            if (joinProperty != null) {
                throw new MappingException(String.format("Attempt to add Join property %s but already have property %s registered as Join property. Check your entity configuration!", property.getField(), joinProperty.getField()));
            }
            this.joinFieldProperty = property;
        }
    }

    private void warnAboutBothSeqNoPrimaryTermAndVersionProperties() {
        LOGGER.warn("Both SeqNoPrimaryTerm and @Version properties are defined on {}. Version will not be sent in index requests when seq_no is sent!", (Object)this.getType());
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String fieldName) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        return this.fieldNamePropertyCache.computeIfAbsent(fieldName, key -> {
            AtomicReference propertyRef = new AtomicReference();
            this.doWithProperties(property -> {
                if (key.equals(property.getFieldName())) {
                    propertyRef.set(property);
                }
            });
            return (ElasticsearchPersistentProperty)propertyRef.get();
        });
    }

    @Override
    public boolean hasSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty != null;
    }

    @Override
    public boolean hasJoinFieldProperty() {
        return this.joinFieldProperty != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getJoinFieldProperty() {
        return this.joinFieldProperty;
    }

    private IndexCoordinates resolve(IndexCoordinates indexCoordinates) {
        String[] indexNames = indexCoordinates.getIndexNames();
        String[] resolvedNames = new String[indexNames.length];
        for (int i = 0; i < indexNames.length; ++i) {
            String indexName = indexNames[i];
            resolvedNames[i] = this.resolve(indexName);
        }
        return IndexCoordinates.of(resolvedNames);
    }

    private String resolve(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Expression expression = this.getExpressionForIndexName(name);
        String resolvedName = expression != null ? (String)expression.getValue((EvaluationContext)this.indexNameEvaluationContext.get(), String.class) : null;
        return resolvedName != null ? resolvedName : name;
    }

    @Nullable
    private Expression getExpressionForIndexName(String name) {
        return this.indexNameExpressions.computeIfAbsent(name, s -> {
            Expression expr = PARSER.parseExpression(s, ParserContext.TEMPLATE_EXPRESSION);
            return expr instanceof LiteralExpression ? null : expr;
        });
    }

    private EvaluationContext getIndexNameEvaluationContext() {
        Expression expression = this.getExpressionForIndexName(this.getIndexName());
        ExpressionDependencies expressionDependencies = expression != null ? ExpressionDependencies.discover((Expression)expression) : ExpressionDependencies.none();
        return this.getEvaluationContext(null, expressionDependencies);
    }

    @Override
    @Nullable
    public String resolveRouting(T bean) {
        if (this.routing == null) {
            return null;
        }
        ElasticsearchPersistentProperty persistentProperty = (ElasticsearchPersistentProperty)this.getPersistentProperty(this.routing);
        if (persistentProperty != null) {
            Object propertyValue = this.getPropertyAccessor(bean).getProperty((PersistentProperty)persistentProperty);
            return propertyValue != null ? propertyValue.toString() : null;
        }
        try {
            Expression expression = this.routingExpressions.computeIfAbsent(this.routing, arg_0 -> ((SpelExpressionParser)PARSER).parseExpression(arg_0));
            ExpressionDependencies expressionDependencies = ExpressionDependencies.discover((Expression)expression);
            EvaluationContext context = this.getEvaluationContext(null, expressionDependencies);
            context.setVariable("entity", bean);
            return (String)expression.getValue(context, String.class);
        }
        catch (EvaluationException e) {
            throw new InvalidDataAccessApiUsageException("Could not resolve expression: " + this.routing + " for object of class " + bean.getClass().getCanonicalName(), (Throwable)e);
        }
    }

    @Override
    public String settingPath() {
        return ((SettingsParameter)this.settingsParameter.get()).settingPath;
    }

    @Override
    public Settings getDefaultSettings() {
        return ((SettingsParameter)this.settingsParameter.get()).toSettings();
    }

    private SettingsParameter buildSettingsParameter(Class<?> clazz) {
        SettingsParameter settingsParameter = new SettingsParameter();
        Document documentAnnotation = (Document)AnnotatedElementUtils.findMergedAnnotation(clazz, Document.class);
        Setting settingAnnotation = (Setting)AnnotatedElementUtils.findMergedAnnotation(clazz, Setting.class);
        if (documentAnnotation != null) {
            settingsParameter.useServerConfiguration = documentAnnotation.useServerConfiguration();
            settingsParameter.shards = documentAnnotation.shards();
            settingsParameter.replicas = documentAnnotation.replicas();
            settingsParameter.refreshIntervall = documentAnnotation.refreshInterval();
            settingsParameter.indexStoreType = documentAnnotation.indexStoreType();
        }
        if (settingAnnotation != null) {
            this.processSettingAnnotation(settingAnnotation, settingsParameter);
        }
        return settingsParameter;
    }

    private void processSettingAnnotation(Setting settingAnnotation, SettingsParameter settingsParameter) {
        settingsParameter.useServerConfiguration = settingAnnotation.useServerConfiguration();
        settingsParameter.settingPath = settingAnnotation.settingPath();
        settingsParameter.shards = settingAnnotation.shards();
        settingsParameter.replicas = settingAnnotation.replicas();
        settingsParameter.refreshIntervall = settingAnnotation.refreshInterval();
        settingsParameter.indexStoreType = settingAnnotation.indexStoreType();
        String[] sortFields = settingAnnotation.sortFields();
        if (sortFields.length > 0) {
            Setting.SortMissing[] sortMissingValues;
            Setting.SortMode[] sortModes;
            String[] fieldNames = new String[sortFields.length];
            int index = 0;
            for (String propertyName : sortFields) {
                ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)this.getPersistentProperty(propertyName);
                if (property == null) {
                    throw new IllegalArgumentException("sortField property " + propertyName + " not found");
                }
                Field fieldAnnotation = (Field)property.getRequiredAnnotation(Field.class);
                FieldType fieldType = fieldAnnotation.type();
                switch (fieldType) {
                    case Boolean: 
                    case Long: 
                    case Integer: 
                    case Short: 
                    case Byte: 
                    case Float: 
                    case Half_Float: 
                    case Scaled_Float: 
                    case Date: 
                    case Date_Nanos: 
                    case Keyword: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("field type " + (Object)((Object)fieldType) + " not allowed for sortField");
                    }
                }
                if (!fieldAnnotation.docValues()) {
                    throw new IllegalArgumentException("doc_values must be set to true for sortField");
                }
                fieldNames[index++] = property.getFieldName();
            }
            SettingsParameter.access$102(settingsParameter, fieldNames);
            Setting.SortOrder[] sortOrders = settingAnnotation.sortOrders();
            if (sortOrders.length > 0) {
                if (sortOrders.length != sortFields.length) {
                    throw new IllegalArgumentException("@Settings parameter sortFields and sortOrders must have the same size");
                }
                SettingsParameter.access$202(settingsParameter, sortOrders);
            }
            if ((sortModes = settingAnnotation.sortModes()).length > 0) {
                if (sortModes.length != sortFields.length) {
                    throw new IllegalArgumentException("@Settings parameter sortFields and sortModes must have the same size");
                }
                SettingsParameter.access$302(settingsParameter, sortModes);
            }
            if ((sortMissingValues = settingAnnotation.sortMissingValues()).length > 0) {
                if (sortMissingValues.length != sortFields.length) {
                    throw new IllegalArgumentException("@Settings parameter sortFields and sortMissingValues must have the same size");
                }
                SettingsParameter.access$402(settingsParameter, sortMissingValues);
            }
        }
    }

    @Override
    public Dynamic dynamic() {
        return this.dynamic;
    }

    public static class ContextConfiguration {
        private final FieldNamingStrategy fieldNamingStrategy;
        private final boolean writeTypeHints;

        ContextConfiguration(FieldNamingStrategy fieldNamingStrategy, boolean writeTypeHints) {
            this.fieldNamingStrategy = fieldNamingStrategy;
            this.writeTypeHints = writeTypeHints;
        }

        public FieldNamingStrategy getFieldNamingStrategy() {
            return this.fieldNamingStrategy;
        }

        public boolean getWriteTypeHints() {
            return this.writeTypeHints;
        }
    }

    private static class SettingsParameter {
        boolean useServerConfiguration = false;
        @Nullable
        String settingPath;
        short shards;
        short replicas;
        @Nullable
        String refreshIntervall;
        @Nullable
        String indexStoreType;
        @Nullable
        private String[] sortFields;
        @Nullable
        private Setting.SortOrder[] sortOrders;
        @Nullable
        private Setting.SortMode[] sortModes;
        @Nullable
        private Setting.SortMissing[] sortMissingValues;

        private SettingsParameter() {
        }

        Settings toSettings() {
            if (this.useServerConfiguration) {
                return new Settings();
            }
            Settings settings = (Settings)((Settings)new Settings().append("index.number_of_shards", String.valueOf(this.shards))).append("index.number_of_replicas", String.valueOf(this.replicas));
            if (this.refreshIntervall != null) {
                settings.append("index.refresh_interval", this.refreshIntervall);
            }
            if (this.indexStoreType != null) {
                settings.append("index.store.type", this.indexStoreType);
            }
            if (this.sortFields != null && this.sortFields.length > 0) {
                settings.append("index.sort.field", this.sortFields);
                if (this.sortOrders != null && this.sortOrders.length > 0) {
                    settings.append("index.sort.order", this.sortOrders);
                }
                if (this.sortModes != null && this.sortModes.length > 0) {
                    settings.append("index.sort.mode", this.sortModes);
                }
                if (this.sortMissingValues != null && this.sortMissingValues.length > 0) {
                    settings.append("index.sort.missing", this.sortMissingValues);
                }
            }
            return settings;
        }

        static /* synthetic */ String[] access$102(SettingsParameter x0, String[] x1) {
            x0.sortFields = x1;
            return x1;
        }

        static /* synthetic */ Setting.SortOrder[] access$202(SettingsParameter x0, Setting.SortOrder[] x1) {
            x0.sortOrders = x1;
            return x1;
        }

        static /* synthetic */ Setting.SortMode[] access$302(SettingsParameter x0, Setting.SortMode[] x1) {
            x0.sortModes = x1;
            return x1;
        }

        static /* synthetic */ Setting.SortMissing[] access$402(SettingsParameter x0, Setting.SortMissing[] x1) {
            x0.sortMissingValues = x1;
            return x1;
        }
    }
}

