/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formattable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.helper.Reflects;

public class Objects {
    public static JsonObject forJson() {
        return JsonObject.COMPACT;
    }

    public static XmlObject forXml() {
        return XmlObject.COMPACT;
    }

    public static JsonBuilder newJsonBuilder(int capacity) {
        return new JsonBuilder(new StringBuilder(capacity));
    }

    public static XmlBuilder newXmlBuilder(int capacity) {
        return new XmlBuilder(new StringBuilder(capacity));
    }

    public static class XmlBuilder {
        private StringBuilder m_sb;

        public XmlBuilder(StringBuilder sb) {
            this.m_sb = sb;
        }

        public XmlBuilder tag(String name, String value) {
            this.m_sb.append("<").append(name).append(">");
            this.value(value);
            this.m_sb.append("</").append(name).append(">");
            return this;
        }

        public XmlBuilder tagStart(String name) {
            if (name != null) {
                this.m_sb.append("<").append(name).append(">");
            }
            return this;
        }

        public XmlBuilder tagEnd(String name) {
            if (name != null) {
                this.m_sb.append("</").append(name).append(">\r\n");
            }
            return this;
        }

        public XmlBuilder raw(char ch) {
            this.m_sb.append(ch);
            return this;
        }

        public XmlBuilder raw(String rawString) {
            this.m_sb.append(rawString);
            return this;
        }

        public String toString() {
            return this.m_sb.toString();
        }

        public XmlBuilder value(String value) {
            if (value == null) {
                this.m_sb.append("null");
            } else {
                String str = value;
                int len = str.length();
                block5: for (int i = 0; i < len; ++i) {
                    char ch = str.charAt(i);
                    switch (ch) {
                        case '&': {
                            this.m_sb.append("&amp;");
                            continue block5;
                        }
                        case '<': {
                            this.m_sb.append("&lt;");
                            continue block5;
                        }
                        case '>': {
                            this.m_sb.append("&gt;");
                            continue block5;
                        }
                        default: {
                            this.m_sb.append(ch);
                        }
                    }
                }
            }
            return this;
        }
    }

    public static enum XmlObject {
        COMPACT;


        public String from(String name, Object obj) {
            XmlBuilder sb = new XmlBuilder(new StringBuilder(2048));
            HashSet<Object> done = new HashSet<Object>();
            this.fromObject(done, sb, name, obj);
            return sb.toString();
        }

        private void fromArray(Set<Object> done, XmlBuilder sb, String names, String name, Object obj) {
            int len = Array.getLength(obj);
            sb.tagStart(names);
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(obj, i);
                this.fromObject(done, sb, name, element);
            }
            sb.tagEnd(names);
        }

        private void fromCollection(Set<Object> done, XmlBuilder sb, String names, String name, Object obj) {
            sb.tagStart(names);
            for (Object item : (Collection)obj) {
                this.fromObject(done, sb, name, item);
            }
            sb.tagEnd(names);
        }

        private void fromMap(Set<Object> done, XmlBuilder sb, String names, String name, Object obj) {
            sb.tagStart(names);
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                sb.raw('<').raw(name).raw(" key=\"").value(String.valueOf(key)).raw("\">");
                this.fromObject(done, sb, null, value);
                sb.tagEnd(name).raw("\r\n");
            }
            sb.tagEnd(names);
        }

        private void fromObject(Set<Object> done, XmlBuilder sb, String name, Object obj) {
            if (obj == null) {
                sb.raw("<").raw(name).raw("/>");
            } else if (obj instanceof Formattable) {
                sb.tagStart(name);
                sb.raw(String.format("%#s", obj));
                sb.tagEnd(name);
            } else if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                StringWriter writer = new StringWriter(1024);
                sb.tagStart(name);
                sb.tag("name", t.getClass().getName()).raw("\r\n");
                if (t.getMessage() != null) {
                    sb.tag("message", t.getMessage()).raw("\r\n");
                }
                if (t.getStackTrace() != null) {
                    t.printStackTrace(new PrintWriter(writer));
                    sb.tag("stackTrace", writer.toString()).raw("\r\n");
                }
                sb.tagEnd(name);
            } else {
                Class<?> type = obj.getClass();
                if (type == String.class || type == Class.class || type.isEnum()) {
                    sb.tagStart(name);
                    sb.value(obj.toString());
                    sb.tagEnd(name);
                } else if (type.isPrimitive() || Number.class.isAssignableFrom(type) || type == Boolean.class) {
                    sb.tagStart(name);
                    sb.raw(obj.toString());
                    sb.tagEnd(name);
                } else if (type == Date.class) {
                    sb.tagStart(name);
                    sb.value(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj));
                    sb.tagEnd(name);
                } else if (done.contains(obj)) {
                    sb.tagStart(name);
                    sb.raw("<!-- ref -->");
                    sb.tagEnd(name);
                } else {
                    done.add(obj);
                    if (type.isArray()) {
                        this.fromArray(done, sb, null, name, obj);
                    } else if (Collection.class.isAssignableFrom(type)) {
                        this.fromCollection(done, sb, null, name, obj);
                    } else if (Map.class.isAssignableFrom(type)) {
                        this.fromMap(done, sb, null, name, obj);
                    } else {
                        this.fromPojo(done, sb, name, obj);
                    }
                }
            }
        }

        private void fromPojo(Set<Object> done, XmlBuilder sb, String name, Object obj) {
            Class<?> type = obj.getClass();
            if (this.hasToXml(type)) {
                sb.tagStart(name);
                sb.raw((String)Reflects.forMethod().invokeDeclaredMethod(obj, "toXml", new Object[0]));
                sb.tagEnd(name);
                return;
            }
            List<Method> getters = Reflects.forMethod().getMethods(type, new Reflects.IMemberFilter<Method>(){

                @Override
                public boolean filter(Method method) {
                    return Reflects.forMethod().isGetter(method);
                }
            });
            Collections.sort(getters, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            sb.tagStart(name);
            if (getters.isEmpty()) {
                sb.value(obj.toString());
            } else {
                sb.raw("\r\n");
                for (Method getter : getters) {
                    Object value;
                    String key = Reflects.forMethod().getGetterName(getter);
                    try {
                        if (!getter.isAccessible()) {
                            getter.setAccessible(true);
                        }
                        value = getter.invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    if (value == null) continue;
                    this.fromObject(done, sb, key, value);
                }
            }
            sb.tagEnd(name);
        }

        private boolean hasToXml(Class<?> type) {
            try {
                Method method = type.getMethod("toXml", new Class[0]);
                if (method.getParameterTypes().length == 0 && method.getReturnType() == String.class) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static enum JsonObject {
        COMPACT;


        public String from(Object obj) {
            JsonBuilder sb = new JsonBuilder(new StringBuilder(2048));
            HashSet<Object> done = new HashSet<Object>();
            this.fromObject(done, sb, obj);
            return sb.toString();
        }

        private void fromArray(Set<Object> done, JsonBuilder sb, Object obj) {
            int len = Array.getLength(obj);
            sb.raw('[');
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.comma();
                }
                Object element = Array.get(obj, i);
                this.fromObject(done, sb, element);
            }
            sb.raw(']');
        }

        private void fromCollection(Set<Object> done, JsonBuilder sb, Object obj) {
            boolean first = true;
            sb.raw('[');
            for (Object item : (Collection)obj) {
                if (first) {
                    first = false;
                } else {
                    sb.comma();
                }
                this.fromObject(done, sb, item);
            }
            sb.raw(']');
        }

        private void fromMap(Set<Object> done, JsonBuilder sb, Object obj) {
            boolean first = true;
            sb.raw('{');
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (first) {
                    first = false;
                } else {
                    sb.comma();
                }
                sb.key(String.valueOf(key)).colon();
                this.fromObject(done, sb, value);
            }
            sb.raw('}');
        }

        private void fromObject(Set<Object> done, JsonBuilder sb, Object obj) {
            if (obj == null) {
                sb.raw("null");
            } else if (obj instanceof Formattable) {
                sb.raw(String.format("%#s", obj));
            } else if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                StringWriter writer = new StringWriter(1024);
                sb.raw('{');
                sb.key("name").colon().value(t.getClass().getName());
                if (t.getMessage() != null) {
                    sb.raw(',');
                    sb.key("message").colon().value(t.getMessage());
                }
                if (t.getStackTrace() != null) {
                    sb.raw(',');
                    t.printStackTrace(new PrintWriter(writer));
                    sb.key("stackTrace").colon().value(writer.toString());
                }
                sb.raw('}');
            } else {
                Class<?> type = obj.getClass();
                if (type == String.class || type == Class.class || type.isEnum()) {
                    sb.value(obj.toString());
                } else if (type.isPrimitive() || Number.class.isAssignableFrom(type) || type == Boolean.class) {
                    sb.raw(obj.toString());
                } else if (type == Date.class) {
                    sb.value(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj));
                } else if (done.contains(obj)) {
                    sb.raw("{}");
                } else {
                    done.add(obj);
                    if (type.isArray()) {
                        this.fromArray(done, sb, obj);
                    } else if (Collection.class.isAssignableFrom(type)) {
                        this.fromCollection(done, sb, obj);
                    } else if (Map.class.isAssignableFrom(type)) {
                        this.fromMap(done, sb, obj);
                    } else {
                        this.fromPojo(done, sb, obj);
                    }
                }
            }
        }

        private void fromPojo(Set<Object> done, JsonBuilder sb, Object obj) {
            Class<?> type = obj.getClass();
            if (this.hasToString(type)) {
                this.fromObject(done, sb, obj.toString());
                return;
            }
            List<Method> getters = Reflects.forMethod().getMethods(type, new Reflects.IMemberFilter<Method>(){

                @Override
                public boolean filter(Method method) {
                    return Reflects.forMethod().isGetter(method);
                }
            });
            Collections.sort(getters, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            if (getters.isEmpty()) {
                sb.value(obj.toString());
            } else {
                boolean first = true;
                sb.raw("{");
                for (Method getter : getters) {
                    Object value;
                    String key = Reflects.forMethod().getGetterName(getter);
                    try {
                        if (!getter.isAccessible()) {
                            getter.setAccessible(true);
                        }
                        value = getter.invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    if (value == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.comma();
                    }
                    sb.key(key).colon();
                    this.fromObject(done, sb, value);
                }
                sb.raw("}");
            }
        }

        public boolean hasToString(Class<?> type) {
            try {
                Method method = type.getMethod("toString", new Class[0]);
                if (method.getDeclaringClass() != Object.class) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static class JsonBuilder {
        private StringBuilder m_sb;

        public JsonBuilder(StringBuilder sb) {
            this.m_sb = sb;
        }

        public JsonBuilder colon() {
            this.m_sb.append(':');
            return this;
        }

        public JsonBuilder comma() {
            this.m_sb.append(',');
            return this;
        }

        public JsonBuilder key(String key) {
            this.m_sb.append('\"').append(key).append('\"');
            return this;
        }

        public JsonBuilder raw(char ch) {
            this.m_sb.append(ch);
            return this;
        }

        public JsonBuilder raw(String rawString) {
            this.m_sb.append(rawString);
            return this;
        }

        public String toString() {
            return this.m_sb.toString();
        }

        public JsonBuilder trimComma() {
            int len = this.m_sb.length();
            if (len > 0 && this.m_sb.charAt(len - 1) == ',') {
                this.m_sb.setLength(len - 1);
            }
            return this;
        }

        public JsonBuilder value(String value) {
            if (value == null) {
                this.m_sb.append("null");
            } else {
                String str = value;
                int len = str.length();
                this.m_sb.append('\"');
                block6: for (int i = 0; i < len; ++i) {
                    char ch = str.charAt(i);
                    switch (ch) {
                        case '\t': {
                            this.m_sb.append('\\').append('t');
                            continue block6;
                        }
                        case '\r': {
                            this.m_sb.append('\\').append('r');
                            continue block6;
                        }
                        case '\n': {
                            this.m_sb.append('\\').append('n');
                            continue block6;
                        }
                        case '\"': 
                        case '\\': {
                            this.m_sb.append('\\').append(ch);
                            continue block6;
                        }
                        default: {
                            this.m_sb.append(ch);
                        }
                    }
                }
                this.m_sb.append('\"');
            }
            return this;
        }
    }
}

