/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.net.ClientTransport;
import org.unidal.net.SocketAddressProvider;
import org.unidal.net.transport.ClientTransportDescriptor;
import org.unidal.net.transport.ClientTransportHandler;
import org.unidal.net.transport.TransportHub;

@Named(type=ClientTransport.class, instantiationStrategy="per-lookup")
public class DefaultClientTransport
implements ClientTransport {
    @Inject
    private ClientTransportHandler m_handler;
    private ClientTransportDescriptor m_desc = new ClientTransportDescriptor();

    @Override
    public ClientTransport connect(InetSocketAddress ... addresses) {
        final List<InetSocketAddress> list = Arrays.asList(addresses);
        this.m_desc.setAddressProvider(new SocketAddressProvider(){

            @Override
            public List<InetSocketAddress> getAddresses() {
                return list;
            }
        });
        return this;
    }

    @Override
    public ClientTransport connect(SocketAddressProvider provider) {
        this.m_desc.setAddressProvider(provider);
        return this;
    }

    @Override
    public ClientTransport connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    @Override
    public ClientTransport handler(String name, ChannelHandler handler) {
        this.m_desc.addHandler(name, handler);
        return this;
    }

    @Override
    public ClientTransport name(String name) {
        this.m_desc.setName(name);
        return this;
    }

    @Override
    public <T> ClientTransport option(ChannelOption<T> option, T value) {
        this.m_desc.getOptions().put(option, value);
        return this;
    }

    @Override
    public ClientTransport start(TransportHub hub) {
        this.m_desc.setHub(hub);
        this.m_desc.validate();
        this.m_handler.setDescriptor(this.m_desc);
        Threads.forGroup(this.m_desc.getName()).start(this.m_handler);
        this.m_handler.awaitWarmup();
        return this;
    }

    @Override
    public void stop(int timeout, TimeUnit unit) throws InterruptedException {
        this.m_handler.shutdown();
        this.m_handler.awaitTermination(timeout, unit);
    }

    @Override
    public ClientTransport withThreads(int threads) {
        this.m_desc.setThreads(threads);
        return this;
    }
}

