/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Reflects;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Named;
import org.unidal.net.transport.ServerTransportDescriptor;
import org.unidal.net.transport.handler.ServerStateHandler;

@Named(type=ServerTransportHandler.class, instantiationStrategy="per-lookup")
public class ServerTransportHandler
implements Threads.Task,
LogEnabled {
    private ServerTransportDescriptor m_descriptor;
    private ChannelGroup m_channelGroup = new DefaultChannelGroup("Cat", (EventExecutor)GlobalEventExecutor.INSTANCE);
    private CountDownLatch m_latch = new CountDownLatch(1);
    private CountDownLatch m_warmup = new CountDownLatch(1);
    private Logger m_logger;
    private Channel m_channel;

    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.m_latch.await(timeout, unit);
    }

    public void awaitWarmup() throws InterruptedException {
        this.m_warmup.await();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            InetSocketAddress localAddress = this.m_descriptor.getLocalAddress();
            Class<? extends ServerChannel> channelClass = this.m_descriptor.getChannelClass();
            bootstrap.group(this.m_descriptor.getBossGroup(), this.m_descriptor.getGroup()).channel(channelClass);
            bootstrap.childHandler((ChannelHandler)new ServerChannelInitializer());
            for (Map.Entry<ChannelOption<Object>, Object> e : this.m_descriptor.getOptions().entrySet()) {
                bootstrap.childOption(e.getKey(), e.getValue());
            }
            ChannelFuture future = bootstrap.bind((SocketAddress)localAddress).sync();
            if (future.isSuccess()) {
                String address = localAddress.getAddress().getHostAddress();
                int port = localAddress.getPort();
                this.m_warmup.countDown();
                this.m_logger.info(String.format("%s server is listening on %s:%s", this.m_descriptor.getName(), address, port));
            }
            this.m_channel = future.channel();
            this.m_channel.closeFuture().sync();
        }
        catch (Throwable e) {
            this.m_logger.error(e.getMessage(), e);
        }
        finally {
            this.m_descriptor.getBossGroup().shutdownGracefully();
            this.m_descriptor.getGroup().shutdownGracefully();
            this.m_latch.countDown();
        }
    }

    public void setDescriptor(ServerTransportDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    @Override
    public void shutdown() {
        this.m_channel.close();
    }

    private class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        private ServerChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new ChannelGroupHandler()});
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandler()});
            pipeline.addLast(new ChannelHandler[]{new ServerStateHandler(ServerTransportHandler.this.m_descriptor.getName())});
            for (Map.Entry<String, ChannelHandler> e : ServerTransportHandler.this.m_descriptor.getHandlers().entrySet()) {
                String name = e.getKey();
                ChannelHandler handler = e.getValue();
                if (handler instanceof Cloneable) {
                    Method method = Reflects.forMethod().getDeclaredMethod(Object.class, "clone", new Class[0]);
                    method.setAccessible(true);
                    pipeline.addLast(name, (ChannelHandler)method.invoke((Object)handler, new Object[0]));
                    continue;
                }
                pipeline.addLast(name, handler);
            }
        }
    }

    private class ChannelInboundHandler
    extends ByteToMessageDecoder
    implements Cloneable {
        private ChannelInboundHandler() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
            if (buf.readableBytes() < 6) {
                return;
            }
            int index = buf.readerIndex();
            short b1 = buf.getUnsignedByte(index);
            short b2 = buf.getUnsignedByte(index + 1);
            int length = buf.getInt(index + 2);
            if (b1 != 202 || b2 != 254) {
                throw new DecoderException("Bad header bytes!");
            }
            if (buf.readableBytes() >= length + 6) {
                ByteBuf frame = buf.slice(index + 6, length);
                buf.readerIndex(index + 6 + length);
                ServerTransportHandler.this.m_descriptor.getHub().onMessage(frame, ctx.channel());
            }
        }
    }

    private class ChannelGroupHandler
    extends ChannelInboundHandlerAdapter
    implements Cloneable {
        private ChannelGroupHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            ServerTransportHandler.this.m_channelGroup.add((Object)channel);
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            ServerTransportHandler.this.m_channelGroup.remove((Object)channel);
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.channel().close();
        }
    }
}

