/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.tuple;

import org.unidal.tuple.Tuple;

public class Triple<F, M, L>
implements Tuple {
    private volatile F m_first;
    private volatile M m_middle;
    private volatile L m_last;

    public Triple() {
    }

    public Triple(F first, M middle, L last) {
        this.m_first = first;
        this.m_middle = middle;
        this.m_last = last;
    }

    public static <F, M, L> Triple<F, M, L> from(F first, M middle, L last) {
        return new Triple<F, M, L>(first, middle, last);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Triple) {
            Triple o = (Triple)obj;
            if (this.m_first == null ? o.m_first != null : !this.m_first.equals(o.m_first)) {
                return false;
            }
            if (this.m_middle == null ? o.m_middle != null : !this.m_middle.equals(o.m_middle)) {
                return false;
            }
            return !(this.m_last == null ? o.m_last != null : !this.m_last.equals(o.m_last));
        }
        return false;
    }

    @Override
    public <T> T get(int index) {
        switch (index) {
            case 0: {
                return (T)this.m_first;
            }
            case 1: {
                return (T)this.m_middle;
            }
            case 2: {
                return (T)this.m_last;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Index from 0 to %s, but was %s!", this.size(), index));
    }

    public F getFirst() {
        return this.m_first;
    }

    public L getLast() {
        return this.m_last;
    }

    public M getMiddle() {
        return this.m_middle;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_first == null ? 0 : this.m_first.hashCode());
        hash = hash * 31 + (this.m_middle == null ? 0 : this.m_middle.hashCode());
        hash = hash * 31 + (this.m_last == null ? 0 : this.m_last.hashCode());
        return hash;
    }

    public void setFirst(F first) {
        this.m_first = first;
    }

    public void setLast(L last) {
        this.m_last = last;
    }

    public void setMiddle(M middle) {
        this.m_middle = middle;
    }

    @Override
    public int size() {
        return 3;
    }

    public String toString() {
        return String.format("Triple[first=%s, middle=%s, last=%s]", this.m_first, this.m_middle, this.m_last);
    }
}

