/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.unidal.concurrent.Actor;
import org.unidal.concurrent.ActorContext;
import org.unidal.concurrent.ActorState;
import org.unidal.concurrent.StageStatus;
import org.unidal.concurrent.internals.ActorManager;
import org.unidal.concurrent.internals.DefaultStageStatus;
import org.unidal.lookup.annotation.Named;

@Named(type=ActorManager.class, instantiationStrategy="per-lookup")
public class DefaultActorManager<E>
implements ActorManager<E> {
    private List<Actor<E, ?>> m_actors = new ArrayList();

    @Override
    public void addActor(Actor<E, ?> actor) {
        this.m_actors.add(actor);
    }

    private void distribute(ActorContext<E> ctx, E event, AtomicBoolean enabled) throws InterruptedException {
        boolean success = ctx.addLast(event);
        while (!success && enabled.get()) {
            success = ctx.addLast(event);
        }
    }

    @Override
    public void distribute(E event, AtomicBoolean enabled) throws InterruptedException {
        int len = this.m_actors.size();
        for (int i = 0; i < len; ++i) {
            Actor<E, ?> actor = this.m_actors.get(i);
            this.distribute((ActorContext<E>)actor.getContext(), event, enabled);
        }
    }

    @Override
    public Actor<E, ?> getNextActor() {
        int len = this.m_actors.size();
        int max = 0;
        int index = -1;
        for (int i = 0; i < len; ++i) {
            int available;
            Actor<E, ?> actor = this.m_actors.get(i);
            ActorState state = actor.checkState();
            if (state == null || !state.isRunnable() || (available = actor.getContext().available()) <= max) continue;
            max = available;
            index = i;
        }
        if (index >= 0) {
            return this.m_actors.get(index);
        }
        return null;
    }

    @Override
    public void report(StageStatus status) {
        int len = this.m_actors.size();
        int[] counts = new int[len];
        for (int i = 0; i < len; ++i) {
            int count;
            Actor<E, ?> actor = this.m_actors.get(i);
            counts[i] = count = actor.getContext().available();
        }
        if (status instanceof DefaultStageStatus) {
            ((DefaultStageStatus)status).setAvailableCounts(counts);
        }
    }
}

