/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent.internals;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.unidal.concurrent.Actor;
import org.unidal.concurrent.Stage;
import org.unidal.concurrent.StageConfiguration;
import org.unidal.concurrent.StageStatus;
import org.unidal.concurrent.internals.ActorManager;
import org.unidal.concurrent.internals.DefaultStageConfiguration;
import org.unidal.concurrent.internals.DefaultStageStatus;
import org.unidal.concurrent.internals.ThreadPool;
import org.unidal.concurrent.internals.ThreadPoolManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=Stage.class, instantiationStrategy="per-lookup")
public class DefaultStage<E>
implements Stage<E> {
    @Inject
    private ThreadPoolManager m_poolManager;
    @Inject
    private ActorManager<E> m_actorManager;
    private String m_id;
    private ThreadPool m_pool;
    private StageConfiguration m_config = new DefaultStageConfiguration();
    private AtomicBoolean m_enabled = new AtomicBoolean(true);
    private CountDownLatch m_latch = new CountDownLatch(1);
    private DefaultStageStatus m_status;

    @Override
    public void add(Actor<E, ?> actor) {
        this.m_actorManager.addActor(actor);
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.m_id);
    }

    @Override
    public StageStatus getStatus() {
        return this.m_status;
    }

    @Override
    public boolean distribute(E event) throws InterruptedException {
        if (this.m_enabled.get()) {
            this.m_actorManager.distribute(event, this.m_enabled);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_pool = this.m_poolManager.getThreadPool(this.m_id);
            this.m_pool.start(this, this.m_config);
            int index = 0;
            while (this.m_enabled.get()) {
                int interval = 1000;
                long deadline = System.currentTimeMillis() + (long)interval;
                DefaultStageStatus status = new DefaultStageStatus(interval);
                this.m_actorManager.report(status);
                this.m_pool.report(status);
                this.m_pool.adjust(status, this.m_status);
                this.m_status = status;
                if (index++ % 1 == 0) {
                    System.out.println(status);
                }
                this.sleepUntil(deadline);
            }
        }
        catch (InterruptedException index) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.m_latch.countDown();
        }
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public int show() throws InterruptedException {
        Actor<E, ?> actor = this.m_actorManager.getNextActor();
        if (actor != null) {
            actor.play();
            return actor.getContext().getProcessed();
        }
        return 0;
    }

    @Override
    public void shutdown() {
        this.m_enabled.set(false);
        try {
            this.m_latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_pool.shutdown();
    }

    private void sleepUntil(long deadline) throws InterruptedException {
        long now;
        while ((now = System.currentTimeMillis()) < deadline) {
            TimeUnit.MILLISECONDS.sleep(deadline - now);
        }
    }
}

