/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.ConverterManager;
import org.unidal.converter.TypeUtil;

public class ArrayConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        if (fromClass.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(fromClass);
    }

    @Override
    public Object convert(Object from, Type targetType) throws ConverterException {
        Object array;
        Class<?> clazz = TypeUtil.getRawType(from.getClass());
        Class<?> componentType = ((Class)targetType).getComponentType();
        if (clazz.isArray()) {
            int length = Array.getLength(from);
            array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(from, i);
                Object element = ConverterManager.getInstance().convert(item, componentType);
                Array.set(array, i, element);
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            List fromList = (List)from;
            int length = fromList.size();
            array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object item = fromList.get(i);
                Object element = ConverterManager.getInstance().convert(item, componentType);
                Array.set(array, i, element);
            }
        } else {
            throw new ConverterException("Unknown type: " + from.getClass());
        }
        return array;
    }

    @Override
    public Type getTargetType() {
        return Array.class;
    }
}

