/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.ConverterManager;
import org.unidal.converter.TypeUtil;

public class ListConverter<T>
implements Converter<List<T>> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        if (fromClass.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(fromClass);
    }

    @Override
    public List<T> convert(Object from, Type targetType) throws ConverterException {
        ArrayList<Object> list;
        Class<?> clazz = TypeUtil.getRawType(from.getClass());
        Type componentType = TypeUtil.getComponentType(targetType);
        if (clazz.isArray()) {
            int length = Array.getLength(from);
            list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(from, i);
                Object element = ConverterManager.getInstance().convert(item, componentType);
                list.add(element);
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            List fromList = (List)from;
            list = new ArrayList(fromList.size());
            for (Object item : fromList) {
                Object element = ConverterManager.getInstance().convert(item, componentType);
                list.add(element);
            }
        } else {
            throw new ConverterException("Unknown type: " + from.getClass());
        }
        return list;
    }

    @Override
    public Type getTargetType() {
        return List.class;
    }
}

