/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.initialization;

import java.util.HashMap;
import java.util.Map;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.lookup.ComponentLookupException;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.extension.Contextualizable;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.logging.TimedConsoleLoggerManager;

@Named(type=ModuleContext.class)
public class DefaultModuleContext
implements ModuleContext,
Contextualizable {
    private PlexusContainer m_container;
    private Map<String, Object> m_attributes = new HashMap<String, Object>();
    private Logger m_logger;

    public DefaultModuleContext() {
    }

    public DefaultModuleContext(PlexusContainer container) {
        this.m_container = container;
        this.setup();
    }

    @Override
    public void contextualize(Map<String, Object> context) {
        this.m_container = (PlexusContainer)context.get("plexus");
        this.setup();
    }

    @Override
    public void error(String message) {
        this.m_logger.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.m_logger.error(message, e);
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        Object value = this.m_attributes.get(name);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public PlexusContainer getContainer() {
        return this.m_container;
    }

    @Override
    public Module[] getModules(String ... names) {
        Module[] modules = new Module[names.length];
        int index = 0;
        for (String name : names) {
            modules[index++] = this.lookup(Module.class, name);
        }
        return modules;
    }

    @Override
    public void info(String message) {
        this.m_logger.info(message);
    }

    @Override
    public <T> T lookup(Class<T> role) {
        return this.lookup(role, null);
    }

    @Override
    public <T> T lookup(Class<T> role, String roleHint) {
        try {
            return this.m_container.lookup(role, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to get component: " + role + ".", e);
        }
    }

    @Override
    public void release(Object component) {
        this.m_container.release(component);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.put(name, value);
    }

    private void setup() {
        try {
            this.m_logger = this.m_container.getLogger();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get instance of Logger, please make sure the environment was setup correctly!", e);
        }
        this.skipClassForLogger(this.getClass());
    }

    public void skipClassForLogger(Class<?> clazz) {
        TimedConsoleLoggerManager.skipClass(clazz);
    }

    @Override
    public void warn(String message) {
        this.m_logger.warn(message);
    }
}

