/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.configuration;

import java.util.List;
import org.unidal.lookup.configuration.Configuration;
import org.unidal.lookup.container.model.entity.Any;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.container.model.entity.ConfigurationModel;
import org.unidal.lookup.container.model.entity.RequirementModel;

public class Component {
    private ComponentModel m_model = new ComponentModel();

    public <T> Component(Class<T> roleClass) {
        this(roleClass, null, roleClass);
    }

    public <T> Component(Class<T> roleClass, Class<? extends T> implementationClass) {
        this(roleClass, null, implementationClass);
    }

    public <T> Component(Class<T> roleClass, Object roleHint, Class<? extends T> implementationClass) {
        this.m_model.setRole(roleClass.getName());
        this.m_model.setImplementation(implementationClass.getName());
        if (roleHint != null) {
            this.m_model.setRoleHint(roleHint.toString());
        }
    }

    public Component config(Configuration ... children) {
        ConfigurationModel config = this.m_model.getConfiguration();
        if (config == null) {
            config = new ConfigurationModel();
            this.m_model.setConfiguration(config);
        }
        List<Any> configuration = config.getDynamicElements();
        for (Configuration child : children) {
            if (child == null) continue;
            configuration.add(new Any().setName(child.getName()).setValue(child.getValue()));
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Component) {
            String role2;
            Component other = (Component)obj;
            String role1 = this.m_model.getRole();
            if (!role1.equals(role2 = other.m_model.getRole())) {
                return false;
            }
            String roleHint1 = this.m_model.getHint();
            String roleHint2 = other.m_model.getHint();
            if (roleHint1 == null && roleHint2 == null) {
                return true;
            }
            if (roleHint1 != null && roleHint2 != null) {
                return roleHint1.equals(roleHint2);
            }
        }
        return false;
    }

    public ComponentModel getModel() {
        return this.m_model;
    }

    public int hashCode() {
        String role = this.m_model.getRole();
        String roleHint = this.m_model.getHint();
        return role.hashCode() * 31 + (roleHint == null ? 0 : roleHint.hashCode());
    }

    public Component is(String instantiationStrategy) {
        this.m_model.setInstantiationStrategy(instantiationStrategy);
        return this;
    }

    public Component req(Class<?> ... roleClasses) {
        for (Class<?> roleClass : roleClasses) {
            this.req(roleClass, "default", null);
        }
        return this;
    }

    public Component req(Class<?> roleClass, String roleHint) {
        return this.req(roleClass, roleHint, null);
    }

    public Component req(Class<?> roleClass, String roleHint, String fieldName) {
        RequirementModel requirement = new RequirementModel();
        requirement.setRole(roleClass.getName());
        requirement.setFieldName(fieldName);
        if (roleHint != null) {
            requirement.setRoleHint(roleHint);
        }
        this.m_model.addRequirement(requirement);
        return this;
    }

    public Component req(Class<?> roleClass, String[] roleHints, String fieldName) {
        RequirementModel requirement = new RequirementModel();
        requirement.setRole(roleClass.getName());
        requirement.setFieldName(fieldName);
        Any hints = new Any().setName("role-hints");
        requirement.getDynamicElements().add(hints);
        for (String roleHint : roleHints) {
            hints.addChild(new Any().setName("role-hint").setValue(roleHint));
        }
        this.m_model.addRequirement(requirement);
        return this;
    }

    public String toString() {
        return this.m_model.toString();
    }
}

