/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Reflects;
import org.unidal.helper.Splitters;
import org.unidal.lookup.ComponentLookupException;
import org.unidal.lookup.container.ComponentKey;
import org.unidal.lookup.container.lifecycle.ComponentLifecycle;
import org.unidal.lookup.container.model.entity.ComponentModel;

public class ComponentBox<T> {
    private Map<String, T> m_components = new HashMap<String, T>();
    private ComponentLifecycle m_lifecycle;

    public ComponentBox(ComponentLifecycle lifecycle) {
        this.m_lifecycle = lifecycle;
    }

    private T createInstance(ComponentModel model) throws ComponentLookupException {
        String message;
        Class<?> clazz = Reflects.forClass().getClass(model.getImplementation());
        Throwable cause = null;
        try {
            if (clazz != null) {
                return (T)clazz.newInstance();
            }
            message = String.format("Class(%s) is not found!", model.getImplementation());
        }
        catch (InstantiationException e) {
            message = String.format("Class(%s) is not accessible!", clazz.getName());
            cause = e;
        }
        catch (IllegalAccessException e) {
            message = String.format("Constructor of class(%s) is not accessible!", clazz.getName());
            cause = e;
        }
        catch (NoClassDefFoundError e) {
            message = String.format("Class(%s) is not found!", clazz.getName());
            cause = e;
        }
        throw new ComponentLookupException(message, model.getRole(), model.getHint(), cause);
    }

    public void destroy() {
        for (T component : this.m_components.values()) {
            this.m_lifecycle.stop(component);
        }
        this.m_components.clear();
    }

    private T getEnumField(ComponentModel model) throws ComponentLookupException {
        String message;
        Class<?> clazz = Reflects.forClass().getClass(model.getImplementation());
        if (clazz.isEnum()) {
            Object[] values = (Object[])Reflects.forMethod().invokeStaticMethod(clazz, "values", new Object[0]);
            List<String> parts = Splitters.by(':').split(model.getHint());
            String field = parts.get(0);
            for (Object value : values) {
                if (!value.toString().equals(field)) continue;
                return (T)value;
            }
            message = String.format("No field(%s) of class(%s) is found!", field, clazz.getName());
        } else {
            message = String.format("Class(%s) is not enum!", clazz.getName());
        }
        throw new ComponentLookupException(message, model.getRole(), model.getHint());
    }

    public T lookup(ComponentModel model) throws ComponentLookupException {
        String roleHint = model.getHint();
        T component = this.m_components.get(roleHint);
        if (component == null) {
            this.m_lifecycle.onStarting(model);
            if (model.isSingleton()) {
                component = this.createInstance(model);
            } else if (model.isPerLookup()) {
                component = this.createInstance(model);
            } else if (model.isEnum()) {
                component = this.getEnumField(model);
            } else {
                throw new UnsupportedOperationException("Unknown instantiation strategy of component: " + model);
            }
            if (!model.isPerLookup()) {
                this.m_components.put(roleHint, component);
            }
            this.m_lifecycle.start(component, model);
            this.m_lifecycle.onStarted(model);
        }
        return component;
    }

    public ComponentBox<T> register(ComponentKey key, T component) {
        this.m_components.put(key.getRoleHint(), component);
        return this;
    }

    public String toString() {
        return String.format("%s[components=%s]", this.getClass().getSimpleName(), this.m_components.size());
    }
}

