/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container.model.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.container.model.BaseEntity;
import org.unidal.lookup.container.model.IVisitor;

public class Any
extends BaseEntity<Any> {
    private String m_name;
    private String m_value;
    private Map<String, String> m_attributes;
    private List<Any> m_children;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitAny(this);
    }

    public Any addChild(Any any) {
        this.children(false).add(any);
        return this;
    }

    protected Map<String, String> attributes(boolean readonly) {
        if (this.m_attributes == null) {
            if (readonly) {
                return Collections.emptyMap();
            }
            this.m_attributes = new HashMap<String, String>();
        }
        return this.m_attributes;
    }

    protected List<Any> children(boolean readonly) {
        if (this.m_children == null) {
            if (readonly) {
                return Collections.emptyList();
            }
            this.m_children = new ArrayList<Any>();
        }
        return this.m_children;
    }

    public List<Any> getAllChildren(String name) {
        ArrayList<Any> all = new ArrayList<Any>();
        for (Any child : this.m_children) {
            if (!child.getName().equals(name)) continue;
            all.add(child);
        }
        return all;
    }

    public String getAttribute(String name) {
        return this.attributes(true).get(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes(false);
    }

    public List<Any> getChildren() {
        return this.children(true);
    }

    public Any getFirstChild(String name) {
        for (Any child : this.children(true)) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean hasValue() {
        return this.m_value != null;
    }

    @Override
    public void mergeAttributes(Any other) {
        this.attributes(false).putAll(other.getAttributes());
    }

    public Any setAttribute(String name, String value) {
        this.attributes(false).put(name, value);
        return this;
    }

    public Any setName(String name) {
        this.m_name = name;
        return this;
    }

    public Any setValue(String value) {
        this.m_value = value;
        return this;
    }

    @Override
    public String toString() {
        if (this.m_value != null) {
            return String.format("<%s>%s</%1$s>", this.m_name, this.m_value);
        }
        return super.toString();
    }
}

