/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.util.HashSet;
import java.util.Set;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.AbstractLoggerManager;
import org.unidal.lookup.logging.LoggerManager;
import org.unidal.lookup.logging.TimedConsoleLogger;

@Named(type=LoggerManager.class)
public class TimedConsoleLoggerManager
extends AbstractLoggerManager {
    private static Set<String> s_skipedClassNames = new HashSet<String>();
    private String m_dateFormat = "MM-dd HH:mm:ss.SSS";
    private boolean m_showClass = true;
    private int m_threshold = 1;
    private AbstractLogger m_logger;

    public static boolean shouldSkipClass(String className) {
        return s_skipedClassNames.contains(className);
    }

    public static void skipClass(Class<?> clazz) {
        s_skipedClassNames.add(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractLogger createLogger(String name) {
        if (this.m_logger == null) {
            TimedConsoleLoggerManager timedConsoleLoggerManager = this;
            synchronized (timedConsoleLoggerManager) {
                if (this.m_logger == null) {
                    TimedConsoleLogger logger = new TimedConsoleLogger(this.m_threshold, name, this.m_dateFormat, this.m_showClass);
                    this.m_logger = logger;
                }
            }
        }
        return this.m_logger;
    }

    public void setDateFormat(String dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public void setShowClass(boolean showClass) {
        this.m_showClass = showClass;
    }

    @Deprecated
    public void setLogFilePattern(String logFilePattern) {
    }

    @Deprecated
    public void setBaseDirRef(String baseDirRef) {
    }

    @Deprecated
    public void setDefaultBaseDir(String defaultBaseDir) {
    }
}

