/**
 * Project Name:activity-center-api
 * File Name:RemoteActivityCategoryBackendService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice
 * Date:2016年6月7日上午8:52:18
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityCategoryBackendService <br/>
 * Function: 活动类目管理的后台接口 <br/>
 * Date:     2016年6月7日 上午8:52:18 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteActivityCategoryBackendService {
    /**
     * 创建一个活动分类
     *
     * @author xuhengfei
     * @param name
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> createCategory(String name);
    /**
     * 修改活动分类的皮肤
     *
     * @author xuhengfei
     * @param id
     * @param content
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> editCategoryContent(long id,String content);
    /**
     * 启用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> enableCategory(long id);
    /**
     * 禁用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> disableCategory(long id);
    /**
     * 查询所有的活动分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityCategoryDto>> findAll();
}

