package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by yansen on 16/6/12.
 */
public interface RemoteOperatingActivityOptionsService {

    //from HdtoolSimpleDAO

    public DubboResult<OperatingActivityOptionsDto> findOptionById(Long id);

    public DubboResult<List<OperatingActivityOptionsDto>> findByOperatingActivityId(Long operatingActivityId);

    public DubboResult<Integer> countByOperatingActivityId(Long operatingActivityId);

    //from HdtoolTextChangeDAO


    public DubboResult<Integer> decrementOptionRemaining(Long optionId);

    public DubboResult<Integer> incrementOptionRemaining(Long optionId);

    public DubboResult<Integer> updateOptionDeleteStatus(List<Long> oaoList);

    public DubboResult<Integer> updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDO);

    public DubboResult<OperatingActivityOptionsDto> insertOption(OperatingActivityOptionsDto operatingActivityOptionsDO);

    public DubboResult<Integer> updateOption(OperatingActivityOptionsDto operatingActivityOptionsDO);

    //from OperatingActivityOptionsStatusChangeDAO

    /**
     * 增加奖品数量
     */
    public DubboResult<Integer> addRemainingById(Long id, Integer addRemaining);

    /**
     * 减少奖品数量
     */
    public DubboResult<Integer> subRemainingById(Long id, Integer subRemaining);

    /**
     * 更新库存
     */
    public DubboResult<Integer> updateRemainingById(Long id, Integer remaining);
}
