/**
 * Project Name:activity-center-api
 * File Name:RemoteActivityCategoryBackendService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice
 * Date:2016年6月7日上午8:52:18
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityCategoryBackendService <br/>
 * Function: 活动类目管理的前台接口 <br/>
 * Date:     2016年6月7日 上午8:52:18 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteActivityCategoryService {

    /**
     * 查询所有的活动分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    DubboResult<ActivityCategoryDto> findById(long id);

    /**
     * 
     * findAllActivitiesByAppCategory:查询App下某个分类的所有活动列表. <br/>
     * 
     * 开发者子页面展示活动用，要求此活动兑吧与开发者均处于开启状态.<br/>
     * 当operating_activity表中的状态被置为关闭时，删除关系表数据，当置为开启时，新增关系表数据.<br/>
     * 开启需要考虑的点：计划任务推送，人为点击开启
     * 关闭需要考虑的点：管理员关闭活动，人为点击关闭
     * 
     * @author wubo
     * @param appId 应用id
     * @param categoryId 活动类目id
     * @return CategoryActivityDto
     * @since JDK 1.6
     */
    DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId,long categoryId,int start,int pageSize);

}
