package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;

import java.util.List;
import java.util.Map;

/**
 * 兑吧活动工具业务DAO
 */
public interface RemoteDuibaHdtoolServiceNew {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaHdtoolDto> findAutoOff();

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolDto find(Long id);

	/**
	 * 活动工具分页列表
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap);

	/**
	 * 统计活动工具条数
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap);

	/**
	 * 根据APP查询活动工具
	 */
	public List<AddActivityDto> findAllDuibaHdTools(Long appId);

	/**
	 * 根据ID集合查询活动工具
	 */
	public List<DuibaHdtoolDto> findAllByIds(List<Long> ids);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId);

	/**
	 * 根据活动ID查询奖项
	 */
	public Map<Long, List<DuibaHdtoolOptionsDto>> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds);

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsDto findOptionById(Long id);
	
	/**
	 * 根据活动ID查询定向
	 */
	public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId);

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId);

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	public Map<Long, HdtoolAppSpecifyDto> findSpecifyByHdToolIdsAndApp(List<Long> duibaHdToolIds, Long appId);

	/**
	 * 根据ID查询定向关系
	 */
	public HdtoolAppSpecifyDto findSpecifyById(Long id);
	
	/**
	 * 根据ID查询额外信息
	 */
	public ActivityExtraInfoDto findExtraInfoById(Long id);


	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * @param queryMap
	 * @return
	 */
	public Long getCountDuibaHdTool(Map<String, Object> queryMap);

	/**
	 * @param queryMap
	 * @return
	 */
	public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap);

	//from DuibaHdtoolTextChangeDao


	public int updateAutoOffDateNull(Long id);

	/**
	 * 新增兑吧活动工具
	 */
	public DuibaHdtoolDto insert(DuibaHdtoolDto duibaHdtoolDto);

	/**
	 * 删除兑吧活动
	 */
	public int deleteById(Long id);

	/**
	 * 修改兑吧活动工具
	 */
	public int update(DuibaHdtoolDto duibaHdtoolDto);

	/**
	 * 修改活动工具状态
	 */
	public int updateStatus(Long id, Integer status);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(Long id);

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 新增兑换活动工具奖项
	 */
	public DuibaHdtoolOptionsDto insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 删除定向关系
	 */
	public int deleteSpecifyById(Long id);

	/**
	 * 添加定向关系
	 */
	public HdtoolAppSpecifyDto insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO);

	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId);
	/**
	 * 根据ID查询标签
	 */
	public String findTag(Long id);
}
