/**
 * Project Name:activity-center-api
 * File Name:RemoteCreditGameSkinService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.creditgame
 * Date:2016年9月10日下午5:22:01
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteCreditGameSkinService <br/>
 * Function: 积分游戏皮肤接口. <br/>
 * Date:     2016年9月10日 下午5:22:01 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteCreditGameSkinService {
    /**
     * find:根据id查询.不包含dom信息 <br/>
     * 无缓存
     * @author wubo
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<CreditGameSkinDto> find(Long id);
    
    /**
     * 
     * findByActivityId:根据积分游戏id查询，不包含dom信息. <br/>
     * 有缓存
     * @author wubo
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<CreditGameSkinDto> findByActivityId(Long activityId);
    
    /**
     * add:添加. <br/>
     *
     * @author wubo
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> add(CreditGameSkinDto dto);
    
    /**
     * edit:编辑. <br/>
     *
     * @author wubo
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> edit(CreditGameSkinDto dto);
    
    /**
     * findWithDomByActivityId:根据积分游戏id查询，包含dom信息. <br/>
     * 有缓存
     * @author wubo
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<CreditGameSkinDto> findWithDomByActivityId(Long activityId);
    
    /**
     * removeKey:此服务用来测试时 删缓存用. <br/>
     * telnet 127.0.0.1 20992
     * invoke cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameSkinService.removeKey(1)
     * @author wubo
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeKey(Long activityId);
}

