/**
 * Project Name:activity-center-api
 * File Name:ActivityStatusEnum.java
 * Package Name:cn.com.duiba.activity.center.api.enums
 * Date:2016年9月30日下午1:40:15
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:ActivityStatusEnum <br/>
 * Date:     2016年9月30日 下午1:40:15 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum ActivityStatusEnum implements EnumInterface {
    STATUS_OPEN("1", "开启且可见"),

    STATUS_CLOSE_SHOW("2", "关闭且可见"),
    
    STATUS_CLOSE("3", "关闭不可见");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ActivityStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return
     * @since JDK 1.6
     */
    public static ActivityStatusEnum getByCode(String code) {
        for (ActivityStatusEnum enumVal : ActivityStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
    
    public Integer getIntCode(){
        return Integer.valueOf(code);
    }
}

