package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginService.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月13日 下午4:09:53 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface RemoteActivityPluginService {

    /**
     * 
     * findActivityPluginInfoList:(这里用一句话描述这个方法的作用). <br/>
     * 查询插件活动list
     * @return
     * @since JDK 1.6
     */
	DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList();

	/**
	 * 
	 * findBrickById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id查询签到皮肤
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<PopupActivityBrickDto> findBrickById(Long id);
	
	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id查询插件活动
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<ActivityPluginDto> findById(Long id);
	
	
	/**
	 * 
	 * createOrder:(这里用一句话描述这个方法的作用). <br/>
	 * 生成订单  出奖
	 * @param consumerId
	 * @param transfer
	 * @param ip
	 * @param description
	 * @param ua
	 * @param os
	 * @param pluDto
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<String> createOrder(Long consumerId,String transfer,String ip,String description,String ua,String os,ActivityPluginDto pluDto);
	
	/**
	 * 
	 * updateStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id开启插件活动配置
	 * @param id
	 * @param value
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateStatus(Long id,Integer value);

}