package cn.com.duiba.activity.center.api.remoteservice.singlelottery;

/**
 * Created by yansen on 16/6/17.
 */

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;

import java.util.List;
import java.util.Map;

/**
 * 兑吧单品抽奖业务DAO
 */
public interface RemoteDuibaSingleLotteryServiceNew {

    /**
     * 
     * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
     * 查询一天内，需要定时下架的单品抽奖
     * @return
     * @since JDK 1.6
     */
    public List<DuibaSingleLotteryDto> findAutoOff();

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaSingleLotteryDto find(Long id);

    /**
     * 
     * findTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	public String findTagById(Long id);

	/**
	 * 
	 * findSingleLotteryPage:(这里用一句话描述这个方法的作用). <br/>
	 * 单品抽奖分页列表
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
    public List<DuibaSingleLotteryDto> findSingleLotteryPage(Map<String, Object> queryMap);

    /**
     * 
     * findSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 单品抽奖分页条数
     * @param queryMap
     * @return
     * @since JDK 1.6
     */
    public List<DuibaSingleLotteryDto> findSingleLottery(Map<String, Object> queryMap);

    /**
     * 
     * findSingleLotteryPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 获取管理员端单品抽奖活动数目
     * @param queryMap
     * @return
     * @since JDK 1.6
     */
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap);

    /**
     * 
     * findAllDuibaSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 获取可用兑吧单品抽奖
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<AddActivityDto> findAllDuibaSingleLottery(Long appId);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据id集合查询
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaSingleLotteryDto> findAllByIds(List<Long> ids);

    /**
     * 
     * getCountDuibaSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 模糊查询统计
     * @param queryMap
     * @return
     * @since JDK 1.6
     */
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap);

    
    /**
     * 
     * findSpecifyByDuibaSingleLotteryAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧单品和APP查询定向关系
     * @param duibaSingleLotteryId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public SingleLotteryAppSpecifyDto findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId);

    /**
     * 
     * findSpecifyByDuibaSingleLotterysAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧单品和APP查询定向关系
     * @param duibaSingleLotteryIds
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public Map<Long, SingleLotteryAppSpecifyDto> findSpecifyByDuibaSingleLotterysAndApp(List<Long> duibaSingleLotteryIds, Long appId);

    /**
     * 
     * findAllSpecifyByDuibaSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 根据duibaSingleLotteryId查询List
     * @param duibaSingleLotteryId
     * @return
     * @since JDK 1.6
     */
    public List<SingleLotteryAppSpecifyDto> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId);

    /**
     * 
     * findSpecifyById:(这里用一句话描述这个方法的作用). <br/>
     * 通过定向ID查询定向关系
     * @param id
     * @return
     * @since JDK 1.6
     */
    public SingleLotteryAppSpecifyDto findSpecifyById(Long id);

    /**
     * 
     * findHasUserdSingleIds:(这里用一句话描述这个方法的作用). <br/>
     * 查询是否被兑吧单品使用
     * @param itemId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findHasUserdSingleIds(Long itemId);

    /**
     * 
     * findExtraInfoById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public ActivityExtraInfoDto findExtraInfoById(Long id);

    /**
     * 
     * updateAutoOffDate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int updateAutoOffDate(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 新增兑吧单品抽奖
     * @param duibaSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public DuibaSingleLotteryDto insert(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID修改
     * @param duibaSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public int update(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 
     * reduceMainItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 主奖品减数量
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int reduceMainItemRemaining(Long id);

    /**
     * 
     * addMainItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 主奖品添加数量
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int addMainItemRemaining(Long id);

    /**
     * 
     * reduceInciteItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 小奖品减数量
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int reduceInciteItemRemaining(Long id);

    /**
     * 
     * addInciteItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 小奖品加数量
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int addInciteItemRemaining(Long id);

    /**
     * 
     * updateForAdminEdit:(这里用一句话描述这个方法的作用). <br/>
     * 后台编辑更新
     * @param duibaSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public int updateForAdminEdit(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 
     * reduceSpecifyAppRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 减去定向APP数量
     * @param duibaSingleLotteryId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

    /**
     * 
     * addSpecifyAppRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 添加定向APP数量
     * @param duibaSingleLotteryId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

    /**
     * 
     * addSpecifyOrderCount:(这里用一句话描述这个方法的作用). <br/>
     * 加APP定向订单数
     * @param duibaSingleLotteryId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId);

    /**
     * 
     * deleteSpecify:(这里用一句话描述这个方法的作用). <br/>
     * 删除定向
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int deleteSpecify(Long id);

    /**
     * 
     * insertAppSpecify:(这里用一句话描述这个方法的作用). <br/>
     * 添加APP定向关系
     * @param singleLotteryAppSpecifyDO
     * @return
     * @since JDK 1.6
     */
    public SingleLotteryAppSpecifyDto insertAppSpecify(SingleLotteryAppSpecifyDto singleLotteryAppSpecifyDO);

    /**
     * 
     * updateSpecifyRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 修改定向数量
     * @param id
     * @param remaining
     * @return
     * @since JDK 1.6
     */
    public int updateSpecifyRemaining(Long id, Integer remaining);

    /**
     * 
     * updateTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param tag
     * @return
     * @since JDK 1.6
     */
	public int updateTagById(Long id, String tag);

    //DuibaSingleLotteryStatusChangeDAOImpl

	/**
	 * 
	 * addMainItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
	 * 增加主奖品的数量
	 * @param id
	 * @param addMainItemRemaining
	 * @return
	 * @since JDK 1.6
	 */
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining);

    /**
     * 
     * subMainItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 减少主奖品的数量
     * @param id
     * @param subMainItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining);

    /**
     * 
     * addInciteItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 增加鼓励奖数量
     * @param id
     * @param addInciteItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining);

    /**
     * 
     * subInciteItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 减少鼓励奖数量
     * @param id
     * @param subInciteItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining);

    /**
     * 查询主奖数量及小奖数量，加锁
     * @param id
     * @return
     */
    public DuibaSingleLotteryDto findForupdate(Long id);

    /**
     * 加锁
     * @param id
     * @return
     */
    public SingleLotteryAppSpecifyDto findSpecifyForupdate(Long id);
}

