package cn.com.duiba.activity.center.api.dto.chaos;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/6/22.
 */
public class ActPreStockDto implements Serializable{

    private static final long serialVersionUID = 1809602666770261570L;
    
    public static final String ACTION_PAY = "pay";
    public static final String ACTION_BACK = "back";
    
    public static final String BIZ_SOURCE_SINGLELOTTERY= "singlelottery";
    public static final String BIZ_SOURCE_HDTOOL = "hdtool";
    public static final String BIZ_SOURCE_ROB = "rob";

    private Long id;

    private Long relationConfigId;

    private Long relationPrizeId;

    private String relationType;

    private String prizeName;

    private Long prizeQuantity;

    private Long appId;

    private Integer deleted;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 
     * Creates a new instance of ActPreStockDto.
     *
     * @param init4insert
     */
    public ActPreStockDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    /**
     * 
     * Creates a new instance of ActPreStockDto.
     *
     */
    public ActPreStockDto() {
    }

    /**
     * 
     * Creates a new instance of ActPreStockDto.
     *
     * @param id
     */
    public ActPreStockDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     * 
     * ClassName: PrizeSure <br/>
     * date: 2016年11月30日 下午4:36:01 <br/>
     *
     * @version ActPreStockDto
     * @since JDK 1.6
     */
    public static class PrizeSure implements Serializable {
        private static final long serialVersionUID = 3987636045723365357L;
        private Long id;
        private Long value;
        public Long getId() {
            return id;
        }
        public void setId(Long id) {
            this.id = id;
        }
        public Long getValue() {
            return value;
        }
        public void setValue(Long value) {
            this.value = value;
        }


    }

    /**
     * 
     * ClassName: JsonSures <br/>
     * date: 2016年11月30日 下午4:36:15 <br/>
     *
     * @version ActPreStockDto
     * @since JDK 1.6
     */
    public static class JsonSures implements Serializable{
        private static final long serialVersionUID = 6581939349380671119L;
        private Long id;
        private String name;
        private List<PrizeSure> admeasure;

        public Long getId() {
            return id;
        }
        public void setId(Long id) {
            this.id = id;
        }
        public String getName() {
            return name;
        }
        public void setName(String name) {
            this.name = name;
        }
        public List<PrizeSure> getAdmeasure() {
            return admeasure;
        }
        public void setAdmeasure(List<PrizeSure> admeasure) {
            this.admeasure = admeasure;
        }

    }

    /**
     * 
     * ClassName: Prizes <br/>
     * date: 2016年11月30日 下午4:39:16 <br/>
     *
     * @version ActPreStockDto
     * @since JDK 1.6
     */
    public static class Prizes implements Serializable{
        private static final long serialVersionUID = 9127156916779093763L;
        private Long id;
        private String name;
        private Long count;


        public Long getId() {
            return id;
        }
        public void setId(Long id) {
            this.id = id;
        }
        public String getName() {
            return name;
        }
        public void setName(String name) {
            this.name = name;
        }
        public Long getCount() {
            return count;
        }
        public void setCount(Long count) {
            this.count = count;
        }
    }

    /**
     * 
     * ClassName: JsonStock <br/>
     * date: 2016年11月30日 下午4:39:28 <br/>
     *
     * @version ActPreStockDto
     * @since JDK 1.6
     */
    public static class JsonStock implements Serializable{
        private static final long serialVersionUID = -3633001224701536853L;
        private List<JsonSures> admeasures;
        private List<Prizes> prizes;
        private String title;
        public List<JsonSures> getAdmeasures() {
            return admeasures;
        }
        public void setAdmeasures(List<JsonSures> admeasures) {
            this.admeasures = admeasures;
        }
        public List<Prizes> getPrizes() {
            return prizes;
        }
        public void setPrizes(List<Prizes> prizes) {
            this.prizes = prizes;
        }
        public String getTitle() {
            return title;
        }
        public void setTitle(String title) {
            this.title = title;
        }

    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRelationConfigId() {
        return relationConfigId;
    }

    public void setRelationConfigId(Long relationConfigId) {
        this.relationConfigId = relationConfigId;
    }

    public Long getRelationPrizeId() {
        return relationPrizeId;
    }

    public void setRelationPrizeId(Long relationPrizeId) {
        this.relationPrizeId = relationPrizeId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType == null ? null : relationType.trim();
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName == null ? null : prizeName.trim();
    }

    public Long getPrizeQuantity() {
        return prizeQuantity;
    }

    public void setPrizeQuantity(Long prizeQuantity) {
        this.prizeQuantity = prizeQuantity;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
