package cn.com.duiba.activity.center.api.dto.ngame;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * ClassName: DuibaNgameStockConsumeDto <br/>
 * date: 2016年12月1日 上午9:46:44 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public class DuibaNgameStockConsumeDto implements Serializable {
	private static final long  serialVersionUID       = -325231231141224121L;

	public static final String ACTION_PAY = "pay";
	public static final String ACTION_BACK = "back";

	private Long id;
	private Long gameStockId;
	private Long optionId;
	private String bizId;
	private String action;
	private Integer quantity;
	private Long appId;
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 
	 * Creates a new instance of DuibaNgameStockConsumeDto.
	 *
	 */
	public DuibaNgameStockConsumeDto() {

	}

	/**
	 * 
	 * Creates a new instance of DuibaNgameStockConsumeDto.
	 *
	 * @param id
	 */
	public DuibaNgameStockConsumeDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 
	 * Creates a new instance of DuibaNgameStockConsumeDto.
	 *
	 * @param init4insert
	 */
	public DuibaNgameStockConsumeDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getGameStockId() {
		return gameStockId;
	}

	public void setGameStockId(Long gameStockId) {
		this.gameStockId = gameStockId;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getOptionId() {
		return optionId;
	}

	public void setOptionId(Long optionId) {
		this.optionId = optionId;
	}
	
}
