package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: RemoteDuibaQuestionAnswerOrdersService <br/>
 * date: 2016年12月1日 下午2:44:45 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaQuestionAnswerOrdersService {

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param order
     * @return
     * @since JDK 1.6
     */
	DuibaQuestionAnswerOrdersDto insert(DuibaQuestionAnswerOrdersDto order);

	/**
	 * 
	 * updateStatusToConsumeSuccess:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	void updateStatusToConsumeSuccess(Long id);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DuibaQuestionAnswerOrdersDto find(Long id);

	/**
	 * 
	 * updateStatusToConsumeFail:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @since JDK 1.6
	 */
	void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer);
	/**
	 * 
	 * updateStatusToSuccess:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	void updateStatusToSuccess(Long id);
	/**
	 * 
	 * updateDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param bizId
	 * @since JDK 1.6
	 */
	void updateDeveloperBizId(Long questionOrderId, String bizId);

	/**
	 * 
	 * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	/**
	 * 
	 * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);
	
	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	/**
	 * 
	 * updateExchangeStatusToFail:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @since JDK 1.6
	 */
	void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	/**
	 * 
	 * updateMainOrderId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param mainOrderId
	 * @param mainOrderNum
	 * @since JDK 1.6
	 */
	void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum);

	/**
	 * 
	 * updateExchangeStatusToOverdue:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	/**
	 * 
	 * updateExchangeStatusToSucess:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	/**
	 * 
	 * updateExchangeStatusToWait:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	/**
	 * 
	 * doTakePrize:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @return
	 * @since JDK 1.6
	 */
	int doTakePrize(Long questionOrderId);

	/**
	 * 
	 * rollbackTakePrize:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrderId
	 * @since JDK 1.6
	 */
	void rollbackTakePrize(Long questionOrderId);

	/**
	 * 
	 * findOverdueOrder:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	List<Long> findOverdueOrder();

	/**
	 * 
	 * findByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionIds
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaQuestionAnswerOrdersDto> findByIds(List<Long> questionIds);

	/**
	 * 
	 * updatePrizeInfo:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOrdersDO
	 * @since JDK 1.6
	 */
    void updatePrizeInfo(DuibaQuestionAnswerOrdersDto questionOrdersDO);

    /**
     * @param orderId
     * @param rightCount
     */
    void updateScore(Long orderId, Integer rightCount);

    /**
     * @param id
     * @param bizId
     * @return
     */
    DuibaQuestionAnswerOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId);
    
    /**
     * 
     * findQuestionOrderLimit50:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    List<DuibaQuestionAnswerOrdersDto> findQuestionOrderLimit50(Long appId, Long activityId);

    /**
     * 
     * updateLuckPrizeNone:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param order
     * @return
     * @since JDK 1.6
     */
	int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDto order);

	/**
	 * 
	 * countFailByOperatingActivityIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids);

	/**
	 * 
	 * findByLimit:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaQuestionAnswerOrdersDto> findByLimit(Map<String, Object> queryMap);

	/**
	 * 
	 * totalCount:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	Long totalCount(Map<String, Object> queryMap);

}
