package cn.com.duiba.activity.center.api.remoteservice.guess;


import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessOptionsDto;

import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: RemoteDuibaGuessOptionsService <br/>
 * date: 2016年12月1日 下午3:01:31 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaGuessOptionsService {
	
    /**
     * 
     * findByGuessId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param guessId
     * @return
     * @since JDK 1.6
     */
	public List<DuibaGuessOptionsDto> findByGuessId(Long guessId);
	/**
	 * 
	 * findByGuessIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param guessIds
	 * @return
	 * @since JDK 1.6
	 */
	public Map<Long, List<DuibaGuessOptionsDto>> findByGuessIds(List<Long> guessIds);
	
	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaGuessOptionsDto findById(Long id);
	
	/**
	 * 
	 * findByAutoOpen:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param guessId
	 * @param autoOpen
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaGuessOptionsDto> findByAutoOpen(Long guessId, boolean autoOpen);
	
	/**
	 * 
	 * findByAutoOpenAsc:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param guessId
	 * @param autoOpen
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaGuessOptionsDto> findByAutoOpenAsc(Long guessId, boolean autoOpen);


	//from manager
	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public int delete(List<Long> ids);
	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaGuessOptionsDto
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaGuessOptionsDto insert(DuibaGuessOptionsDto duibaGuessOptionsDto);
	/**
	 * 
	 * updateInfoForm:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaGuessOptionsDto
	 * @return
	 * @since JDK 1.6
	 */
	public int updateInfoForm(DuibaGuessOptionsDto duibaGuessOptionsDto);

	/**
	 * 
	 * updateRemainingById:(这里用一句话描述这个方法的作用). <br/>
	 * 更新库存
	 * @param id
	 * @param remaining
	 * @return
	 * @since JDK 1.6
	 */
	public int updateRemainingById(Long id, Integer remaining);
	
}
