package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginBackendService.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午3:52:35 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 * @return  
 */
public interface RemoteActivityPluginBackendService {
	
    /**
     * 
     * createActivityPluginInfo:(这里用一句话描述这个方法的作用). <br/>
     * 插入插件活动配置项
     * @param activityPluginDto
     * @return
     * @since JDK 1.6
     */
	DubboResult<ActivityPluginDto> createActivityPluginInfo(ActivityPluginDto activityPluginDto);

	/**
	 * 
	 * updateActivityPluginInfo:(这里用一句话描述这个方法的作用). <br/>
	 * 编辑插件活动配置
	 * @param activityPluginDto
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateActivityPluginInfo(ActivityPluginDto activityPluginDto);
	
	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id查询插件活动
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<ActivityPluginDto> findById(Long id);

	/**
	 * 
	 * updateStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id开启插件活动配置
	 * @param id
	 * @param value
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateStatus(Long id,Integer value);
	
	/**
	 * 
	 * dellActivityPlugin:(这里用一句话描述这个方法的作用). <br/>
	 * 删除插件活动
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> dellActivityPlugin(Long id);

	/**
	 * 
	 * findActivityPluginInfoList:(这里用一句话描述这个方法的作用). <br/>
	 * 查询插件活动list
	 * @param id
	 * @param title
	 * @param offset
	 * @param max
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList(Long id,String title,Integer offset, Integer max);
	
	/**
	 * 
	 * findPageCount:(这里用一句话描述这个方法的作用). <br/>
	 * 查询插件活动满足条件的总条数
	 * @param id
	 * @param title
	 * @param offset
	 * @param max
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Long> findPageCount(Long id,String title,Integer offset, Integer max);
	
	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 修改自动下架时间
	 * @param autoOffDate
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
    public DubboResult<Integer> updateAutoOffDateNull(Date autoOffDate, Long id);
}