package cn.com.duiba.activity.center.api.remoteservice.quizz;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;

/**
 * 
 * ClassName: RemoteQuizzOrdersStatusChangeService <br/>
 * date: 2016年12月1日 下午5:18:48 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteQuizzOrdersStatusChangeService {

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * @param quizzOrdersDto
     * @param id
     * @return
     * @since JDK 1.6
     */
	public QuizzOrdersDto insert(QuizzOrdersDto quizzOrdersDto, long id);
	
	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public QuizzOrdersDto find(Long consumerId, Long id);

	/**
	 * 
	 * updateExchangeStatusToFail:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param id
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer,
                                   String error4consumer);

    /**
     * 
     * updateExchangeStatusToOverdue:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单领奖状态为过期失效
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * updateStatusToFail:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单状态失败
     * @param consumerId
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * doTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 处理领奖
     * @param consumerId
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer doTakePrize(Long consumerId, Long id);

    /**
     * 
     * rollbackTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 领奖创建订单失败，回滚领奖
     * @param consumerId
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer rollbackTakePrize(Long consumerId, Long id);

    /**
     * 
     * updateLotteryResult:(这里用一句话描述这个方法的作用). <br/>
     * 处理抽奖结果
     * @param consumerId
     * @param id
     * @param appItemId
     * @param itemId
     * @param prizeId
     * @param prizeName
     * @param prizeType
     * @param prizeFacePrice
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName,
                                String prizeType, String prizeFacePrice, Long couponId);

    /**
     * 
     * updateLotteryLuckResult:(这里用一句话描述这个方法的作用). <br/>
     * 福袋请求降级处理时更新订单为谢谢参与
     * @param consumerId
     * @param id
     * @param appItemId
     * @param itemId
     * @param prizeId
     * @param prizeName
     * @param prizeType
     * @param prizeFacePrice
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    public Integer updateLotteryLuckResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId,
                                    String prizeName, String prizeType, String prizeFacePrice, Long couponId);
}
