package cn.com.duiba.activity.center.api.remoteservice.seckill;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillAppSpecifyDto;

/**
 * 
 * ClassName: RemoteDuibaSeckillAppSpecifyService <br/>
 * date: 2016年12月1日 下午5:26:27 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaSeckillAppSpecifyService {
	
    /**
     * 
     * findActivityIdsByAppId:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId查询定向的活动id列表
     * @param appId
     * @return
     * @since JDK 1.6
     */
	List<Long> findActivityIdsByAppId(Long appId);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillAppSpecifyDto find(Long id);

	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @since JDK 1.6
	 */
	public void delete(Long id);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSeckillAppSpecify
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillAppSpecifyDto insert(DuibaSeckillAppSpecifyDto duibaSeckillAppSpecify);

	/**
	 * 
	 * findByDuibaSeckillId:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSeckillId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillAppSpecifyDto> findByDuibaSeckillId(Long duibaSeckillId);

	/**
	 * 
	 * findByDuibaSeckillAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSeckillId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillAppSpecifyDto findByDuibaSeckillAndApp(Long duibaSeckillId, Long appId);

	/**
	 * 
	 * findByDuibaSeckillsAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSeckillIds
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public Map<Long, DuibaSeckillAppSpecifyDto> findByDuibaSeckillsAndApp(List<Long> duibaSeckillIds, Long appId);
}
