package cn.com.duiba.activity.center.api.remoteservice.seckill;


import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillStockConfigDto;

import java.util.Date;
import java.util.List;

/**
 * 
 * ClassName: RemoteDuibaSeckillStockConfigService <br/>
 * date: 2016年12月1日 下午5:31:23 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaSeckillStockConfigService {
    
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	DuibaSeckillStockConfigDto find(Long id);

	/**
	 * 
	 * findByUnique:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param skillId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	DuibaSeckillStockConfigDto findByUnique(Long skillId, Long appId);

	/**
	 * 
	 * consumeStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	int consumeStock(Long id);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param config
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillStockConfigDto insert(DuibaSeckillStockConfigDto config);

	/**
	 * 
	 * findBySeckillId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param seckillId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillStockConfigDto> findBySeckillId(Long seckillId);

	/**
	 * 
	 * getStockConfigMaxPayload:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param seckillId
	 * @return
	 * @since JDK 1.6
	 */
	public int getStockConfigMaxPayload(Long seckillId);

	/**
	 * 
	 * findBySeckillIdAndAppIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param seckillId
	 * @param appIds
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillStockConfigDto> findBySeckillIdAndAppIds(Long seckillId, List<Long> appIds);
	
	/**
	 * 
	 * invocationStockConfig:(这里用一句话描述这个方法的作用). <br/>
	 * 重新启用被删除的子库存
	 * @param config
	 * @return
	 * @since JDK 1.6
	 */
	public int invocationStockConfig(DuibaSeckillStockConfigDto config);

	/**
	 * 
	 * markDelStockConfig:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param config
	 * @since JDK 1.6
	 */
	public void markDelStockConfig(DuibaSeckillStockConfigDto config);

	/**
	 * 
	 * setDay:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param configId
	 * @param day
	 * @since JDK 1.6
	 */
	public void setDay(Long configId, Date day);

	/**
	 * 
	 * setPayload:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param configId
	 * @param payload
	 * @return
	 * @since JDK 1.6
	 */
	public int setPayload(Long configId, Integer payload);
	
}
