package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.dcommons.enums.AppBannerSourceTypeEnum;
import cn.com.duiba.dcommons.enums.AppItemSourceTypeEnum;
import com.google.common.collect.ImmutableSet;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/13.
 */
public class OperatingActivityDto implements Serializable{

    // type int 删除移到common-service中的常量
    public static final int TypeDuibaActivity = 0; //专题活动
    public static final int TypeTurnTable = 1; // 大转盘活动
    public static final int TypeDuibaSingleLottery = 2; // 兑吧单品抽奖
    public static final int TypeAppSingleLottery = 3; // App自有单品抽奖
    public static final int TypeDuibaTurntable = 4; //兑吧大转盘
    public static final int TypeAppManualLottery = 5; //app自有手动开奖
    public static final int TypeShakeLottery = 6;//摇一摇
    public static final int TypeScratchCard = 7;//刮刮卡
    public static final int TypeHdToolTurntable = 8;//活动工具大转盘
    public static final int TypeHdToolTiger = 9;//老虎机
    public static final int TypeHdToolFlop = 10;//趣味翻牌
    public static final int TypeHdToolSmashg = 11;//砸彩蛋
    public static final int TypeSecondsKill = 30;//周三必抢

    public static final int TypeGameSanta = 20;//游戏活动-打劫圣诞老人
    public static final int TypeGameYearAward = 21;//游戏活动-数年终奖
    public static final int TypeGameGirl = 22;//游戏活动-女神pk
    public static final int TypeGameJiong = 23;//游戏活动-人在囧途
    //增加游戏的时候，请把新增的游戏类型加到下面的ImmutableSet《《《《《——————————注意
    public static final ImmutableSet<Integer> GAME_TYPES = ImmutableSet.of(TypeGameSanta,TypeGameYearAward,TypeGameGirl,TypeGameJiong);
    public static final int TypeDuibaQuestionAnswer = 40;	// 兑吧答题
    public static final int TypeDuibaQuizz = 41;	// 测试题
    public static final int TypeDuibaSeckill = 31;	// 兑吧秒杀活动
    public static final int TypeDuibaNgame = 28;	// 兑吧新游戏
    public static final int TypeDuibaGuess = 42;   // 兑吧竞猜
    public static final int TypeDuibaRob = 45;     // 今日必抢

    //Start chaijiangang,幸运转盘改为活动工具,2016/04/12
    public static final String TypeShakeLottery_Action = "shake";//摇一摇
    public static final String TypeScratchCard_Action = "ScratchCard";//刮刮卡
    public static final String TypeHdToolTurntable_Action = "turntableNew";//活动工具大转盘
    public static final String TypeHdToolTiger_Action = "tiger";//老虎机
    public static final String TypeHdToolFlop_Action = "flop";//趣味翻牌
    public static final String TypeHdToolSmashg_Action = "smashg";//砸彩蛋
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    //从此判断活动工具变得很容易！！
    public static final ImmutableSet<Integer> hdToolTypeSet = ImmutableSet.of(TypeShakeLottery,TypeScratchCard,TypeHdToolTurntable,TypeHdToolTiger,TypeHdToolFlop,TypeHdToolSmashg);

    public static final int StatusIntNoComplete = 0; //数据不完整
    public static final int StatusIntComplete = 1; //数据完整
    public static final int StatusIntOpen = 2; //开启
    public static final int StatusIntClose = 3; //关闭

    //Start chaijiangang,幸运转盘改为活动工具,2016/04/12
    public static final int DoJoinStatusNoCredits = 2;//积分不足
    public static final int DoJoinStatusNoFreeEveryDay = 3;//今日没有抽奖次数
    public static final int DoJoinStatusNoFree = 4;//没有抽奖次数
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12
    
    public static final int SWITCHES_HDTOOLS_NEW = 1;//新活动工具
    public static final int ANTICHEAT_LIMIT_RULE = 5; // 开启直充类奖品防刷
    
    private static final long serialVersionUID = -1137126468254229534L;
    private Long id;
    private Long appId; //appId
    private String title; //标题
    private Integer type; //活动类型
    private Integer status; //数据状态  引用：StatusInt*
    private Long appBannerId; //首页bannerID
    private Long appItemId; //兑换项ID
    private Long consumeCredits; // 消耗的总积分数
    private Integer consumeMoney;// 消耗的总金钱数
    private Integer visitTimes; // 参与人数
    private Integer winTimes; // 中奖人数
    private Long credits; // 消耗积分数
    private Integer limitCount; // 每日最多几次
    private Integer freeLimit; // 每日免费次数
    private String rule;// 活动规则
    private String explainText; // 活动说明
    private String image; // 主图
    private String smallImage;//缩略图
    private String logo;//小图标
    private String bannerImage;//banner
    private Long activityId; //引用活动ID,  如：兑吧专题活动，兑吧单品抽奖，兑吧大转盘.....
    private Integer activityOrderQuantity; //活动订单数
    private Integer failCount; // 领取失败数量， 数据库无此字段
    private Long parentActivityId;
    private Boolean deleted; // 是否已经删除
    private Date gmtCreate; //创建时间
    private Date gmtModified; //变更时间
    private Integer creditsType;//积分模式
    private String subType;//活动模版
    private String freeScope;//免费参数次数限制类型
    private String limitScope;//参与次数限制类型
    private String rateIntroduction;	// 概率说明
    private Long customCredits;	// 抽奖积分
    //Start guoeryang,直充类奖品防刷,2016/06/14
    private String exchangeLimit;//商品防刷
    //End guoeryang,直充类奖品防刷,2016/06/14
    private Integer switches;

    public OperatingActivityDto(){}

    public OperatingActivityDto(Integer type){
        this.type = type;
    }
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    public OperatingActivityDto(boolean init4insert) {
        if (init4insert) {
            consumeCredits = 0L;
            consumeMoney = 0;
            visitTimes = 0;
            winTimes = 0;
            credits = 0L;
            limitCount = 0;
            switches = 0;
            activityOrderQuantity = 0;
            deleted = false;
            gmtCreate = new Date();
            gmtModified = gmtCreate;

        }
    }

    public OperatingActivityDto(Long id) {
        this.id = id;
        this.gmtModified=new Date();
    }
    public String getExchangeLimit() {
		return exchangeLimit;
	}

	public void setExchangeLimit(String exchangeLimit) {
		this.exchangeLimit = exchangeLimit;
	}
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAppBannerId() {
        return appBannerId;
    }

    public void setAppBannerId(Long appBannerId) {
        this.appBannerId = appBannerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getConsumeCredits() {
        return consumeCredits;
    }

    public void setConsumeCredits(Long consumeCredits) {
        this.consumeCredits = consumeCredits;
    }

    public Integer getConsumeMoney() {
        return consumeMoney;
    }

    public void setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
    }

    public Integer getVisitTimes() {
        return visitTimes;
    }

    public void setVisitTimes(Integer visitTimes) {
        this.visitTimes = visitTimes;
    }

    public Integer getWinTimes() {
        return winTimes;
    }

    public void setWinTimes(Integer winTimes) {
        this.winTimes = winTimes;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Integer getFreeLimit() {
        return freeLimit;
    }

    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getExplainText() {
        return explainText;
    }

    public void setExplainText(String explainText) {
        this.explainText = explainText;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityOrderQuantity() {
        return activityOrderQuantity;
    }

    public void setActivityOrderQuantity(Integer activityOrderQuantity) {
        this.activityOrderQuantity = activityOrderQuantity;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public Long getParentActivityId() {
        return parentActivityId;
    }

    public void setParentActivityId(Long parentActivityId) {
        this.parentActivityId = parentActivityId;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getCreditsType() {
        return creditsType;
    }

    public void setCreditsType(Integer creditsType) {
        this.creditsType = creditsType;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getFreeScope() {
        return freeScope;
    }

    public void setFreeScope(String freeScope) {
        this.freeScope = freeScope;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getRateIntroduction() {
        return rateIntroduction;
    }

    public void setRateIntroduction(String rateIntroduction) {
        this.rateIntroduction = rateIntroduction;
    }

    public Long getCustomCredits() {
        return customCredits;
    }

    public void setCustomCredits(Long customCredits) {
        this.customCredits = customCredits;
    }

    public int getAppItemSourceType() {
        switch (this.type) {
            case TypeDuibaActivity: // 专题活动 ok
                return AppItemSourceTypeEnum.SourceTypeDuibaActivity.getCode();
            case TypeTurnTable: // 大转盘活动
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
                return AppItemSourceTypeEnum.SourceTypeSingleLottery.getCode();
            case TypeAppSingleLottery: // App自有单品抽奖 ok
                return AppItemSourceTypeEnum.SourceTypeSingleLottery.getCode();
            case TypeDuibaTurntable: // 兑吧大转盘 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeAppManualLottery: // app自有手动开奖 ok
                return AppItemSourceTypeEnum.SourceTypeManualLottery.getCode();
            case TypeShakeLottery: // 摇一摇 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeScratchCard: // 刮刮卡 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolTurntable: // 活动工具大转盘 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolTiger: // 老虎机 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolFlop: // 趣味翻牌 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeSecondsKill: // 秒杀专题
                return AppItemSourceTypeEnum.SourceTypeSecondsKill.getCode();
            case TypeGameSanta: // 圣诞游戏
                return AppItemSourceTypeEnum.SourceTypeGameSanta.getCode();
            case TypeGameYearAward: // 数年终奖游戏
                return AppItemSourceTypeEnum.SourceTypeGameYearAward.getCode();
            case TypeGameGirl: // 女神游戏
                return AppItemSourceTypeEnum.SourceTypeGameGirl.getCode();
            case TypeGameJiong: // 人在囧途
                return AppItemSourceTypeEnum.SourceTypeGameJiong.getCode();
            case TypeDuibaQuestionAnswer: // 兑吧答题活动
                return AppItemSourceTypeEnum.SourceTypeDuibaQuestionAnswer.getCode();
            case TypeDuibaQuizz://测试题活动
                return AppItemSourceTypeEnum.SourceTypeDuibaQuizz.getCode();
            case TypeDuibaNgame://新游戏
                return AppItemSourceTypeEnum.SourceTypeDuibaNgame.getCode();
            case TypeDuibaGuess://竞猜
                return AppItemSourceTypeEnum.SourceTypeDuibaGuess.getCode();
            default:
                return 0;
        }
    }

    public int getAppBannerSourceType() {
        switch (this.type) {
            case TypeDuibaActivity: // 专题活动 ok
                return AppBannerSourceTypeEnum.SourceTypeDuibaActivity.getCode();
            case TypeTurnTable: // 大转盘活动
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
                return AppBannerSourceTypeEnum.SourceTypeSingleLottery.getCode();
            case TypeAppSingleLottery: // App自有单品抽奖 ok
                return AppBannerSourceTypeEnum.SourceTypeSingleLottery.getCode();
            case TypeDuibaTurntable: // 兑吧大转盘 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeAppManualLottery: // app自有手动开奖 ok
                return AppBannerSourceTypeEnum.SourceTypeManualLottery.getCode();
            case TypeShakeLottery: // 摇一摇 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeScratchCard: // 刮刮卡 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolTurntable: // 活动工具大转盘 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolTiger: // 老虎机 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolFlop: // 趣味翻牌 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode();
            case TypeSecondsKill: // 秒杀专题
                return AppBannerSourceTypeEnum.SourceTypeSecondsKill.getCode();
            case TypeGameSanta: // 圣诞游戏
                return AppBannerSourceTypeEnum.SourceTypeGameSanta.getCode();
            case TypeGameYearAward: // 数年终奖游戏
                return AppBannerSourceTypeEnum.SourceTypeGameYearAward.getCode();
            case TypeGameGirl: // 女神游戏
                return AppBannerSourceTypeEnum.SourceTypeGameGirl.getCode();
            case TypeGameJiong: //
                return AppBannerSourceTypeEnum.SourceTypeGameJiong.getCode();
            case TypeDuibaQuestionAnswer: // 兑吧答题游戏
                return AppBannerSourceTypeEnum.SourceTypeDuibaQuestionAnswer.getCode();
            case TypeDuibaQuizz://测试题活动
                return AppBannerSourceTypeEnum.SourceTypeDuibaQuizz.getCode();
            case TypeDuibaNgame://新游戏
                return AppBannerSourceTypeEnum.SourceTypeDuibaNgame.getCode();
            case TypeDuibaGuess://竞猜
                return AppBannerSourceTypeEnum.SourceTypeDuibaGuess.getCode();
            default:
                return 0;
        }
    }

    //Start chaijiangang,幸运转盘改为活动工具,2016/04/12
    public String getPreviewAction() {
        switch (this.type) {
            case TypeShakeLottery: // 摇一摇 ok
                return TypeShakeLottery_Action;
            case TypeScratchCard: // 刮刮卡 ok
                return TypeScratchCard_Action;
            case TypeHdToolTurntable: // 活动工具大转盘 ok
                return TypeHdToolTurntable_Action;
            case TypeHdToolTiger: // 老虎机 ok
                return TypeHdToolTiger_Action;
            case TypeHdToolFlop: // 趣味翻牌 ok
                return TypeHdToolFlop_Action;
            case TypeHdToolSmashg: // 砸彩蛋 ok
                return TypeHdToolSmashg_Action;
            default:
                return "";
        }
    }

    /**
     * 判断是否是游戏活动
     * @return
     */
    public boolean isGame(){
        if(this.type == TypeGameSanta
                || this.type == TypeGameYearAward
                || this.type == TypeGameGirl
                || this.type == TypeGameJiong)
            return true;
        else return false;
    }

    /**
     * 判断是否是活动工具
     * @return
     */
    public boolean isHdTool(){
        if(this.type == TypeShakeLottery
                || this.type == TypeScratchCard
                || this.type == TypeHdToolTiger
                || this.type == TypeHdToolTurntable
                || this.type == TypeHdToolFlop
                || this.type == TypeHdToolSmashg)
            return true;
        else return false;
    }
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    //Start chaijiangang,不参与抽奖积分可编辑活动,2016/04/12
    public static boolean isCjTool(Integer types) {
        switch (types) {
            case TypeSecondsKill: // 周三必抢
                return false;
            case TypeDuibaActivity: // 专题活动
                return false;
            case TypeDuibaSeckill: // 兑吧秒杀活动
                return false;
            default:
                return true;
        }
    }
    //End chaijiangang,不参与抽奖积分可编辑活动,2016/04/12

    public Integer getSwitches() {
        return switches;
    }

    
    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public void grantOpSwitches(int opType){
        int v=1<<opType;
        switches=switches | v;
    }
    
    public void ungrantOpSwitches(int opType){
        int v=1<<opType;
        v=~v;
        switches=switches & v;
    }
    
    public boolean isOpSwitches(int opType){
        int v=1<<opType;
        int ret= switches & v;
        return ret!=0;
    }
    
}
