package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import  cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import  cn.com.duiba.activity.center.api.dto.creditgame.GamePreResultDto;
import  cn.com.duiba.activity.center.api.dto.creditgame.CreditGameResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Map;

/**
 * 积分游戏前台接口
 * @author jyc
 * @since 2016-09-05
 */
public interface RemoteCreditGameService {

    /**
     * paly游戏(生成游戏订单、扣除积分)
     * @param creditGameId 积分游戏ID
     * @param consumerId 用户ID
     * @param creditGameStepRecordId 积分游戏步骤记录ID
     * @param creditGamesRuntimeParameters 积分游戏参数Map
     * @return 积分游戏前置结果
     */
    DubboResult<GamePreResultDto> palyCreditGame(Long creditGameId,Long consumerId,String creditGameStepRecordId,Map<String,Object> creditGamesRuntimeParameters);

    /**
     * 获取游戏结果
     * @param creditGameOrderId 积分游戏订单ID
     * @return 积分游戏结果
     */
    DubboResult<CreditGameResultDto> getPalyCreditGameResult(Long creditGameOrderId);

    /**
     * 根据游戏逻辑ID获取游戏实体(出参将不包含大字段)
     * @param creditGameId 积分游戏ID
     * @return 积分游戏实体
     */
    DubboResult<CreditGameDto> getCreditGameById(Long creditGameId);
    
    /**
     * describe : 扣除积分，避免center同级调用
     * @param consumerId
     * @param orederNum
     * @param credits
     * @return
     */
    DubboResult<String> decrementCredit(CreditGameDto creditGame,Long consumerId, String orderNum, Long credits,String ipAddress,String transfer);
    
    /**
     * describe : 加积分
     * @param consumerId
     * @param orederNum
     * @param credits
     */
    DubboResult<String>  incrementCredit(CreditGameDto creditGame,Long consumerId, String orderNum, Long credits, String ipAddress,String transfer);
    
    /**
     * describe : 增加、扣积分后发送通知
     * @author : cdm
     * @date : 2016年9月19日下午4:09:57
     * @param orderNum
     * @return
     */
    DubboResult<String>  crementCreditNotify(String orderNum);
}
