package cn.com.duiba.activity.center.api.remoteservice.direct;


import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by suyuanlong on 16/7/14.
 */
public interface RemoteActivityBlackList4DeveloperService {

    /**
     * @param blackList4DeveloperDto
     * @return id
     */
    DubboResult<ActivityBlackList4DeveloperDto> insertBlack4Developer(ActivityBlackList4DeveloperDto blackList4DeveloperDto);

    /**
     * @param btos
     * @return
     */
    DubboResult<List<ActivityBlackList4DeveloperDto>> insertBlackList4Developer(List<ActivityBlackList4DeveloperDto> btos);

    /**
     * @param id
     * @return 0 1
     */
    DubboResult<Boolean> deleteBlackById(Long id);

//    /**
//     * @param id
//     * @return Dto
//     */
//    DubboResult<ActivityBlackList4DeveloperDto> findById(Long id);

    /**
     * @param activityId
     * @param activityType
     * @return List
     */
    DubboResult<List<ActivityBlackList4DeveloperDto>> findByActivityIdAndActivityType(Long activityId, Integer activityType,Integer offset,Integer limit);

    /**
     * @param activityId
     * @param activityType
     * @return count
     */
    DubboResult<Integer> findCountByActivityIdAndActivityType(Long activityId, Integer activityType);


//    /**
//     * @param activityId
//     * @param activityType
//     * @param developerId
//     * @return count
//     */
//    DubboResult<Integer> findCountByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType, Long developerId);

    /**
     * @param activityId
     * @param activityType
     * @param developerId
     * @return
     */
    DubboResult<Boolean> isExistBlackByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType, Long developerId);
    /**
     * @param List<ActivityBlackList4DeveloperDto> paras
     * @return 黑名单活动id列表
     * @author zhujianda
     * 判断传入的活动是否在黑名单,减少dubbo交互
     */
    public DubboResult<List<Long>> getActivityBlackList(List<ActivityBlackList4DeveloperDto> paras);


    }