package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/7/5.
 */
public interface RemoteHdtoolSkinDataService {

    /**
     * createHdtoolSkinData:(). <br/>
     * 开发者/兑吧编辑活动模版定制后，创建一条模版数据
     * @author zp
     * @param hdtoolSkinData
     * @since JDK 1.6
     */
    public HdtoolSkinDto createHdtoolSkinData(HdtoolSkinDto hdtoolSkinEntity);

    /**
     * 编辑模版数据
     * @author zp
     * @param hdtoolSkinData
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateHdtoolSkinData(Long hdtoolId, String type, String dataJson);
    
    /**
     * 编辑模版数据
     * @param hdtoolSkinData
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateHdtoolSkinDataAppId(Long hdtoolId, String type, String dataJson,Long appId);

    /**
     * 查询活动模版基础配置
     * queryBaseHdtoolSkin:(这里用一句话描述这个方法的作用). <br/>
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkin(Long hdtoolId,String type);
    
    /**
     * 查询活动模版基础配置
     * queryBaseHdtoolSkin:(这里用一句话描述这个方法的作用). <br/>
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkinAppId(Long hdtoolId,String type,Long appId);

    /**
     * 查询活动Json数据
     * @author zp
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> querySkin(Long hdtoolId,String type);

    /**
     * 查询活动Json数据
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> querySkinAppId(Long hdtoolId,String type, Long AppId);
}
