package cn.com.duiba.activity.center.api.remoteservice.singlelottery;

/**
 * Created by yansen on 16/6/17.
 */

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;

import java.util.List;
import java.util.Map;

/**
 * 兑吧单品抽奖业务DAO
 */

public interface RemoteDuibaSingleLotteryServiceNew {
    //DuibaSingleLotterySimpleDAO

    /**
     * 查询一天内，需要定时下架的单品抽奖
     * @return
     */
    public List<DuibaSingleLotteryDto> findAutoOff();

    /**
     * 根据ID查询
     */
    public DuibaSingleLotteryDto find(Long id);

	public String findTagById(Long id);

    /**
     * 单品抽奖分页列表
     */
    public List<DuibaSingleLotteryDto> findSingleLotteryPage(Map<String, Object> queryMap);

    /**
     * 单品抽奖分页条数
     */
    public List<DuibaSingleLotteryDto> findSingleLottery(Map<String, Object> queryMap);

    /**
     * 获取管理员端单品抽奖活动数目
     */
    //Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	/*
	public Long findSingleLotteryPageCount() {
		return this.getSqlSession().selectOne(getStamentNameSpace("findSingleLotteryPageCount"));
	}*/
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap);
    //End chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30

    /**
     * 获取可用兑吧单品抽奖
     */
    public List<AddActivityDto> findAllDuibaSingleLottery(Long appId);

    /**
     * 根据id集合查询
     */
    public List<DuibaSingleLotteryDto> findAllByIds(List<Long> ids);

    /**
     * 模糊查询统计
     */
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap);

    /**
     * 根据兑吧单品和APP查询定向关系
     */
    public SingleLotteryAppSpecifyDto findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId);

    /**
     * 根据兑吧单品和APP查询定向关系
     */
    public Map<Long, SingleLotteryAppSpecifyDto> findSpecifyByDuibaSingleLotterysAndApp(List<Long> duibaSingleLotteryIds, Long appId);

    /**
     * 根据duibaSingleLotteryId查询List
     */
    public List<SingleLotteryAppSpecifyDto> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId);

    /**
     * 通过定向ID查询定向关系
     */
    public SingleLotteryAppSpecifyDto findSpecifyById(Long id);

    /**
     * 查询是否被兑吧单品使用
     * @param itemId
     * @return
     */
    public List<Long> findHasUserdSingleIds(Long itemId);

    /**
     *
     * @param id
     * @return
     */
    public ActivityExtraInfoDto findExtraInfoById(Long id);


    //DuibaSingleLotteryTextChangeDAO


    public int updateAutoOffDate(Long id);

    /**
     * 新增兑吧单品抽奖
     */
    public DuibaSingleLotteryDto insert(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 根据ID修改
     */
    public int update(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 主奖品减数量
     */
    public int reduceMainItemRemaining(Long id);

    /**
     * 主奖品添加数量
     */
    public int addMainItemRemaining(Long id);

    /**
     * 小奖品减数量
     */
    public int reduceInciteItemRemaining(Long id);

    /**
     * 小奖品加数量
     */
    public int addInciteItemRemaining(Long id);

    /**
     * 后台编辑更新
     */
    public int updateForAdminEdit(DuibaSingleLotteryDto duibaSingleLotteryDO);

    /**
     * 减去定向APP数量
     */
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

    /**
     * 添加定向APP数量
     */
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

    /**
     * 加APP定向订单数
     */
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId);

    /**
     * 删除定向
     */
    public int deleteSpecify(Long id);

    /**
     * 添加APP定向关系
     */
    public SingleLotteryAppSpecifyDto insertAppSpecify(SingleLotteryAppSpecifyDto singleLotteryAppSpecifyDO);

    /**
     * 修改定向数量
     */
    public int updateSpecifyRemaining(Long id, Integer remaining);

	public int updateTagById(Long id, String tag);

    //DuibaSingleLotteryStatusChangeDAOImpl


    /**
     * 增加主奖品的数量
     */
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining);

    /**
     * 减少主奖品的数量
     */
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining);

    /**
     * 增加鼓励奖数量
     */
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining);

    /**
     * 减少鼓励奖数量
     */
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining);

    /**
     * 查询主奖数量及小奖数量，加锁
     * @param id
     * @return
     */
    public DuibaSingleLotteryDto findForupdate(Long id);

    /**
     * 加锁
     * @param id
     * @return
     */
    public SingleLotteryAppSpecifyDto findSpecifyForupdate(Long id);
}

