package cn.com.duiba.activity.center.api.dto.singlelottery;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/21.
 */
public class SingleLotteryStockConsumeDto implements Serializable {
    private static final long serialVersionUID = -5463767339966903110L;

    public static final String ACTION_PAY = "pay";
    public static final String ACTION_BACK = "back";
    public static final String OPTION_MAIN = "main";
    public static final String OPTION_INCITE = "incite";
    public static final String TYPE_DUIBA = "duiba";
    public static final String TYPE_DEV_ITEM = "app";
    public static final String BIZ_SOURCE_SPECIFY = "specify";
    public static final String BIZ_SOURCE_NORMAL = "single";

    private Long id;
    private Long relationId;
    private String relationType;
    private String optionType;//大奖，小奖
    private String bizId;
    private String bizSource;
    private String action;
    private Long quantity;
    private Long appId;
    private Date gmtCreate;
    private Date gmtModified;

    public SingleLotteryStockConsumeDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    public SingleLotteryStockConsumeDto() {
    }

    public SingleLotteryStockConsumeDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getQuantity() {
        return quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getOptionType() {
        return optionType;
    }

    public void setOptionType(String optionType) {
        this.optionType = optionType;
    }

    public String getBizSource() {
        return bizSource;
    }

    public void setBizSource(String bizSource) {
        this.bizSource = bizSource;
    }
}
