package cn.com.duiba.activity.center.api.remoteservice.manual;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;

public interface RemoteManualOrderLotteryService {

    /**
     * 查询用户参与活动次数
     */
    Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 查询用户在时间段内参与活动次数
     */
    Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start,
                                                           Date end);

    /**
     * 查询用户免费参与活动次数
     */
    Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 查询用户在时间段内免费参与活动次数
     */
    Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start,
                                                               Date end);

    /**
     * 条件搜索开奖记录
     *
     * @param paramMap
     * @return
     */
    List<ManualLotteryOrderDto> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap);

    /**
     * 条件搜索开奖记录条数
     *
     * @param paramMap
     * @return
     */
    Long findAllOpenManualLotteryCount(Map<String, Object> paramMap);

    /**
     * 查询中奖清单
     *
     * @return
     */
    List<ManualLotteryOrderDto> findWardList(Long operatingActivityId);

    /**
     * 查询参与清单
     *
     * @param paramMap
     * @return
     */
    List<ManualLotteryOrderDto> findNoWardList(Map<String, Object> paramMap);

    /**
     * 查询参与清单count
     *
     * @param paramMap
     * @return
     */
    Long findNoWardListCount(Map<String, Object> paramMap);

    /**
     * 根据ids查询待开奖的用户list
     *
     * @param paramMap
     * @return
     */
    List<ManualLotteryOrderDto> findStartOpenListByIds(Map<String, Object> paramMap);

    /**
     * 更新中奖用户状态
     *
     * @param id
     * @param activityId
     * @param date
     * @return
     */
    int updateAward(Long id, Long activityId, Date date);

    /**
     * 随机抽一条
     *
     * @param paramMap
     * @return
     */
    ManualLotteryOrderDto randomFindManualLottery(Map<String, Object> paramMap);

    /**
     * 更新未中奖用户
     *
     * @param paramMap
     */
    void updateNoAwardList(Map<String, Object> paramMap);

    /**
     * 查询未中奖用户
     *
     * @param paramMap
     * @return
     */
    List<ManualLotteryOrderDto> findAllNoAwardList(Map<String, Object> paramMap);

    /**
     * 查询所有ids
     *
     * @param ids
     * @return
     */
    List<ManualLotteryOrderDto> findAllByIds(List<Long> ids);

    /**
     * 根据订单号查询
     *
     * @param orderId
     * @return
     */
    ManualLotteryOrderDto findByOrderId(Long orderId);

    ManualLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId);

    ManualLotteryOrderDto insert(ManualLotteryOrderDto ManualLotteryOrderDto);

    void update(ManualLotteryOrderDto ManualLotteryOrderDto);

    ManualLotteryOrderDto find(Long id);
}
