package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginBackendService.java <br/>
 * @author  Administrator 
 * @date 创建时间：2016年10月11日 下午3:52:35 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 * @return  
 */
public interface RemoteActivityPluginBackendService {
	/**
	 * 插入插件活动配置项
	 * @param ActivityPluginDto 插件活动配置
	 */
	DubboResult<ActivityPluginDto> createActivityPluginInfo(ActivityPluginDto activityPluginDto);

	/**
	 * 编辑插件活动配置
	 * @param ActivityPluginDto 插件活动配置
	 */
	DubboResult<Integer> updateActivityPluginInfo(ActivityPluginDto activityPluginDto);

	/**
	 * 根据Id查询插件活动
	 * @param 签到编辑
	 * @return 操作结果
	 */
	DubboResult<ActivityPluginDto> findById(Long id);

	/**
	 * 根据Id开启插件活动配置
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<Integer> OpenStatus(Long id);

	/**
	 * 根据Id关闭插件活动配置
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<Integer> CloseStatus(Long id);

	/**
	 * 查询插件活动list
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList(Long id,String title,Integer offset, Integer max);
	
	/**
	 * 查询插件活动满足条件的总条数
	 * @param map
	 * @return 操作结果
	 */
	DubboResult<Long> findPageCount(Long id,String title,Integer offset, Integer max);
}