/**
 * Project Name:activity-center-api
 * File Name:CategoryActivityDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto
 * Date:2016年6月8日下午4:04:25
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.dto;

import java.io.Serializable;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

/**
 * ClassName:CategoryActivityDto <br/>
 * Date:     2016年6月8日 下午4:04:25 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class CategoryActivityDto implements Serializable{
    /**
     * serialVersionUID
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 4075282699378015733L;
    private Long id;
    private Long appId;
    private Long categoryId;
    private String title;           //标题
    private String thumb;           //缩略图
    private String banner;          //banner图
    private Long credits;           //积分值
    private Integer payload;
    private Long operatingId;
    private String link;            //在web端set
    private Long appItemId;

    @Deprecated
    private String st_info;
    private String logo;            //100*100图
    private String whitethumb;      //白底缩略图
    private String recommendImage;  //推荐位图片
    private Integer type;           //活动类型
    private Long activityId;        //兑吧活动id
    
    public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getLink() {
		return link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public Long getAppId() {
        return appId;
    }
    
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    
    public Long getCategoryId() {
        return categoryId;
    }
    
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getThumb() {
        return thumb;
    }
    
    public void setThumb(String thumb) {
        this.thumb = thumb;
    }
    
    public String getBanner() {
        return banner;
    }
    
    public void setBanner(String banner) {
        this.banner = banner;
    }
    
    public Long getCredits() {
        return credits;
    }
    
    public void setCredits(Long credits) {
        this.credits = credits;
    }
    
    public Integer getPayload() {
        return payload;
    }
    
    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    
    public Long getOperatingId() {
        return operatingId;
    }
    
    public void setOperatingId(Long operatingId) {
        this.operatingId = operatingId;
    }

	public String getSt_info() {
		return st_info;
	}

	public void setSt_info(String st_info) {
		this.st_info = st_info;
	}

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getWhitethumb() {
        return whitethumb;
    }

    public void setWhitethumb(String whitethumb) {
        this.whitethumb = whitethumb;
    }

    public String getRecommendImage() {
        return recommendImage;
    }

    public void setRecommendImage(String recommendImage) {
        this.recommendImage = recommendImage;
    }
    
    public Integer getType() {
        return type;
    }

    
    public void setType(Integer type) {
        this.type = type;
    }

    
    public Long getActivityId() {
        return activityId;
    }

    
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
    
    /**
     * 判断是否是活动工具
     * @return
     */
    public boolean isHdTool(){
        if(this.type == OperatingActivityDto.TypeShakeLottery
                || this.type == OperatingActivityDto.TypeScratchCard
                || this.type == OperatingActivityDto.TypeHdToolTiger
                || this.type == OperatingActivityDto.TypeHdToolTurntable
                || this.type == OperatingActivityDto.TypeHdToolFlop
                || this.type == OperatingActivityDto.TypeHdToolSmashg)
            return true;
        else return false;
    }
	
}

