package cn.com.duiba.activity.center.api.dto.plugin;

import java.io.Serializable;
import java.util.Date;

/** 
 * ClassName:ActivityPluginDto.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午7:26:04 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public class ActivityPluginDto implements Serializable {

	private static final long serialVersionUID = 626677009528542670L;
	
	public static final Integer SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
	public static final Integer SWITCHES_ANTICHEAT_LIMIT_RULE = 2; // 开启直充类奖品防刷

	public static final int STATUS_OPEN = 1; // 开启且可见
	public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
	public static final int STATUS_CLOSE = 3; // 关闭不可见
	
	public static final int SIGN_TYPE_FIRST = 0; // 活动有效期内首次登陆
	public static final int SIGN_TYPE_EVERYFIRST = 1; // 活动有效期内每天首次登陆
	public static final int SIGN_TYPE_EVERYTIME = 2; // 有效期内每次访问
	public static final int SIGN_TYPE_NEW_MEMBER = 3; // 新人礼包

	private Long id;
	//皮肤id
	private Long brickId;
	//标题
	private String title;
	//签到规则描述
	private String ruleDescription;
	//概率说明
	private String rateDescription;
	//应用场景 首页：0，活动自页面：1，主会场：2，活动自页面：3 此时 url 才存值
	private String scenarios;
	//trigger_time
	private String triggerTime;
	//触发事件
	private Integer signType;
	//状态（0：关闭，1：开启），默认为0	not null
	private Integer status;
	//位运算标识
	private Integer switches;
	//定时自动下架日期
	private Date autoOffDate;
	//标签
	private String tag;
	//触发结果  1：直接发奖  2  跳转页面
	private Integer triggerTpye;
	//跳转url
	private String triggerUrl;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getBrickId() {
		return brickId;
	}
	public void setBrickId(Long brickId) {
		this.brickId = brickId;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getRuleDescription() {
		return ruleDescription;
	}
	public void setRuleDescription(String ruleDescription) {
		this.ruleDescription = ruleDescription;
	}
	public String getRateDescription() {
		return rateDescription;
	}
	public void setRateDescription(String rateDescription) {
		this.rateDescription = rateDescription;
	}
	public String getScenarios() {
		return scenarios;
	}
	public void setScenarios(String scenarios) {
		this.scenarios = scenarios;
	}
	public String getTriggerTime() {
		return triggerTime;
	}
	public void setTriggerTime(String triggerTime) {
		this.triggerTime = triggerTime;
	}
	public Integer getSignType() {
		return signType;
	}
	public void setSignType(Integer signType) {
		this.signType = signType;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	
	public Integer getSwitches() {
		return switches;
	}
	public void setSwitches(Integer switches) {
		this.switches = switches;
	}
	public Date getAutoOffDate() {
		return autoOffDate;
	}
	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}
	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public String getTag() {
		return tag;
	}
	public void setTag(String tag) {
		this.tag = tag;
	}
	public Integer getTriggerTpye() {
		return triggerTpye;
	}
	public void setTriggerTpye(Integer triggerTpye) {
		this.triggerTpye = triggerTpye;
	}
	public String getTriggerUrl() {
		return triggerUrl;
	}
	public void setTriggerUrl(String triggerUrl) {
		this.triggerUrl = triggerUrl;
	}
	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}
}
